<?php

namespace App\Events;

use App\Http\Resources\DriverShipmentResource;
use App\Models\AppSetting;
use App\Models\Driver;
use App\Models\Rate;
use App\Models\ShipmentDriver;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class UpdateShipmentEvent implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    protected $shipment,$driver,$driversCount;
    public function __construct($shipment,$driver,$driversCount=0)
    {
        $this->shipment=$shipment;
        $this->driver=$driver;
        $this->driversCount=$driversCount;
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('shipments-'.$this->shipment->id);
    }
    public function broadcastWith()
    {
        $data=[];
        $data['id']=$this->driver->id;
        $data['name']=$this->driver->name;
        $data['mobile']=$this->driver->mobile;
        $data['profile_image']=$this->driver->profile_image;
        $data['drivers_Count']=$this->driversCount;
        $data['number_of_trucks']=$this->shipment->number_of_trucks;
        $user_rates = Rate::where('driver_id', $this->driver->id)->get();
        $total=0;
            if (count($user_rates) > 0) {
                foreach ($user_rates as $rate) {
                    $total += $rate->rate;
                }
                $total_rate = $total / count($user_rates);
                $data['rate'] = $total_rate;
            } else {
                $data['rate'] = 0;
            }
            $shipmentDriver=ShipmentDriver::where(['driver_id'=>$this->driver->id,'shipment_id'=>$this->shipment->id])->first();
        $data['price'] = $shipmentDriver->price;

        return $data;


    }
}
