<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\ForbiddenItemsRequest;
use App\Models\ForbiddenItem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Models\ShipmentCountry;
use App\Http\Controllers\Controller;

class ForbiddenItemsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $items = ForbiddenItem::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.forbidden-items.index', compact('items'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.forbidden-items.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(ForbiddenItemsRequest $request)
    {
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image->move(public_path() . '/images/', $image_name);
        ForbiddenItem::create($request->validated() + ['image' => $image_name]);


        return redirect()->route('admin.forbidden-items.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $item = ForbiddenItem::whereId($id)->first();
        return view('admin.pages.forbidden-items.edit', compact('item'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(ForbiddenItemsRequest $request, $id)
    {
        $forbiddenItem = ForbiddenItem::whereId($id)->first();
        $forbiddenItem->update($request->validated());
        if ($request->image) {
            $image = $request->file('image');
            $image_name = time() . '-' . $image->getClientOriginalName();
            $image->move(public_path() . '/images/', $image_name);
            $forbiddenItem->update(['image' => $image_name]);


        }



        return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $forbiddenItem = ForbiddenItem::whereId($id)->first();
        $forbiddenItem->delete();
        return redirect()->route('admin.forbidden-items.index')->with('success', 'Deleted');

    }
}
