<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\NotificationsRequest;
use App\Models\Driver;
use App\Models\Notification;
use App\Models\User;
use App\Services\External\Notification as PushNotificationService;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Gate;

use App\Http\Controllers\Controller;

class NotificationsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
//        abort_if(Gate::denies('all_notifications'), 403);


        $notifications = Notification::where('user_id', 0)
            ->orWhere('driver_id', 0)
            ->orderBy('created_at', 'desc')
            ->with('user')
            ->paginate();
        return view('admin.pages.notifications.index', compact('notifications'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        $users = User::all();
        $drivers = Driver::all();
        return view('admin.pages.notifications.create', compact('users', 'drivers'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return Response
     */
    public function store(NotificationsRequest $request)
    {
        // abort_if(Gate::denies('create_notifications'), 403);

        $notification=Notification::create($request->validated());
        if ($request->user_type == 'users') {
            $notification->update(['user_id'=>0]);

            PushNotificationService::notifyFor('users', $request->title, $request->body);
        } elseif ($request->user_type == 'drivers') {
            $notification->update(['driver_id'=>0]);

            PushNotificationService::notifyFor('drivers', $request->title, $request->body);

        } elseif ($request->user_type == 'user') {
            PushNotificationService::notify('users', 'admin', [$request->user_id], null, $request->title_ar, $request->body_ar, 'Qwater', '');

        } elseif ($request->user_type == 'driver') {

            PushNotificationService::notify('drivers', 'admin', [$request->driver_id], null, $request->title_ar, $request->body_ar, 'Qwater', '');

        }


        return redirect()->route('admin.notifications.index')->with('success', 'Added');


    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return Response
     */
    public function edit($id)
    {
       // abort_if(Gate::denies('edit_notifications'), 403);

        $notification = Notification::whereId($id)->first();
//        $users=User::where('type',0)->get();
        return view('admin::pages.notifications.edit', compact('notification'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request $request
     * @param int $id
     * @return Response
     */
    public function update(NotificationsRequest $request, $id)
    {
       // abort_if(Gate::denies('edit_notifications'), 403);

        $notification = Notification::whereId($id)->first();
        $notification->update($request->validated());
        return redirect()->route('notifications.index')->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return Response
     */
    public function destroy($id)
    {
        //abort_if(Gate::denies('delete_notifications'), 403);

        $notification = Notification::whereId($id)->first();
        $notification->delete();
        return redirect()->route('admin.notifications.index')->with('success', 'Deleted');

    }
}
