<?php

namespace App\Http\Controllers\Admin;

use App\Exports\ReportsExport;
use App\Http\Controllers\Controller;
use App\Models\AppSetting;
use App\Models\Shipment;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Maatwebsite\Excel\Facades\Excel;

class ReportsController extends Controller
{
    public function index(Request $request)
    {
        $from = Carbon::parse($request->from)->toDateString();
        $to = Carbon::parse($request->to)->toDateString() ?? Carbon::now()->toDateString();

        $shipmentQuery = Shipment::orderBy('created_at', 'desc')
            ->when($request->user_id,function ($query)use($request){
                $query->where('sender_id',$request->user_id);
            })
            ->when($request->status,function ($query)use($request){
                $query->where('status',$request->status);
            })
            ->when($request->id,function ($query)use($request){
                $query->where('id',$request->id);
            })
            ->when($request->driver_id,function ($query)use($request){
                $query->whereHas('drivers',function ($query)use($request){
                    $query->where(['shipment_drivers.driver_id'=>$request->driver_id,'shipment_drivers.status'=>1]);
                });
            })
            ->when($request->from && $request->to,function ($query)use($from,$to){
                $query->whereBetween('created_at',[$from,$to]);
            })
            ->whereHas('drivers');
        
        $shipments = $shipmentQuery->paginate();

        $shipmentPrices = $shipmentQuery->sum('final_price');
        $shipmentCount = $shipmentQuery->count();
        $numberOfTrucks = $shipmentQuery->sum('number_of_trucks');


        $appAndTaxPrices = Shipment::with(['drivers' => function ($query) {
            $query->select('shipment_drivers.id', 'shipment_drivers.shipment_id')
                ->selectRaw('SUM(shipment_drivers.app_price) as total_app_price')
                ->selectRaw('SUM(shipment_drivers.tax) as total_tax')
                ->groupBy('shipment_drivers.shipment_id', 'shipment_drivers.id');
        }])->get();

// To get the totals

        $appPrices = $appAndTaxPrices->pluck('drivers')->flatten()->sum('total_app_price');
        $taxPrices = $appAndTaxPrices->pluck('drivers')->flatten()->sum('total_tax');
        $driverPrices = ($shipmentPrices * ((100 - AppSetting::key('app_percentage')->first()->value) / 100)) - $appPrices - $taxPrices;

        return view('admin.pages.reports.index', compact('shipments', 'shipmentPrices', 'shipmentCount', 'numberOfTrucks', 'appPrices',
            'taxPrices', 'driverPrices'
        ));

    }

    public function downloadExcel()
    {

        return Excel::download(new ReportsExport(), 'التقارير.xlsx');

    }
}



