<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\LoginRequest;
use App\Models\Setting;
use App\Http\Requests\Admin\SettingsRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class SettingsController extends Controller
{
    public function index(Request $request){
        $settings=Setting::paginate();
        $type=$request->type;
        return view('admin.pages.settings.index',compact('settings','type'));

    }

    public function edit($id)
    {
        $type=request()->type;
        $setting=Setting::whereId($id)->select('id',request()->type.' As text')->first();

        return view('admin.pages.settings.edit',compact('setting','type'));

    }

    public function update(SettingsRequest $request, $id)
    {
//        abort_if(Gate::denies('edit_categories'), 403);

        $data= $request->validated();

        Setting::whereId($id)->update([
            $request->type=>$request->text
        ]);
        return redirect()->back()->with('success','Updated');

    }

}
