<?php

namespace App\Http\Controllers\Admin;

use App\Models\ShipmentCountry;
use App\Models\ShipmentGovernorate;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\GovernoratesRequest;

class ShipmentGovernoratesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $shipmentGovernorates = ShipmentGovernorate::orderBy('created_at', 'desc')
            ->when($request->country_id,function ($query)use ($request){
                $query->where('shipment_country_id',$request->country_id);
            })
            ->paginate();
        return view('admin.pages.shipment-governorate.index', compact('shipmentGovernorates'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $countries=ShipmentCountry::all();
        return view('admin.pages.shipment-governorate.create',compact('countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(GovernoratesRequest $request)
    {
        ShipmentGovernorate::create($request->validated() );


        return redirect()->route('admin.shipment-governorate.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $shipmentGovernorate = ShipmentGovernorate::whereId($id)->first();
        $countries=ShipmentCountry::all();

        return view('admin.pages.shipment-governorate.edit', compact('shipmentGovernorate','countries'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(GovernoratesRequest $request, $id)
    {
        $shipmentGovernorate = ShipmentGovernorate::whereId($id)->first();
        $shipmentGovernorate->update($request->validated());

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $shipmentGovernorate = ShipmentGovernorate::whereId($id)->first();
        $shipmentGovernorate->delete();
        return redirect()->route('admin.shipment-governorate.index')->with('success', 'Deleted');

    }
}
