<?php

namespace App\Http\Controllers\Admin;
use App\Http\Requests\Admin\TruckLoadCapacitiesRequest;
use App\Http\Requests\Admin\TruckNumberOfAxlesRequest;
use App\Models\TruckLoadCapacity;
use App\Models\TruckNumberOfAxles;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class TruckNumberOfAxlesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckNumberOfAxless = TruckNumberOfAxles::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-number-of-axles.index', compact('truckNumberOfAxless'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-number-of-axles.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckNumberOfAxlesRequest $request)
    {
        TruckNumberOfAxles::create($request->validated());
        return redirect()->route('admin.truck-number-of-axles.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckNumberOfAxles = TruckNumberOfAxles::whereId($id)->first();
        return view('admin.pages.truck-number-of-axles.edit', compact('truckNumberOfAxles'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckNumberOfAxlesRequest $request, $id)
    {
        $truckNumberOfAxles = TruckNumberOfAxles::whereId($id)->first();
        $truckNumberOfAxles->update($request->validated());
       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckNumberOfAxles = TruckNumberOfAxles::whereId($id)->first();
        $truckNumberOfAxles->delete();
        return redirect()->route('admin.truck-number-of-axles.index')->with('success', 'Deleted');

    }
}
