<?php

namespace App\Http\Controllers\Admin;
use App\Http\Requests\Admin\TruckHeightsRequest;
use App\Http\Requests\Admin\TruckModelsRequest;
use App\Http\Requests\Admin\TruckWidthsRequest;
use App\Models\TruckHeight;
use App\Models\TruckModel;
use App\Models\TruckWidth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;

class TruckWidthsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $truckWidths = TruckWidth::orderBy('created_at', 'desc')->paginate();
        return view('admin.pages.truck-widths.index', compact('truckWidths'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.pages.truck-widths.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TruckWidthsRequest $request)
    {
        TruckWidth::create($request->validated());
        return redirect()->route('admin.truck-widths.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truckWidth = TruckWidth::whereId($id)->first();
        return view('admin.pages.truck-widths.edit', compact('truckWidth'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update( TruckWidthsRequest $request, $id)
    {
        $truckWidth = TruckWidth::whereId($id)->first();
        $truckWidth->update($request->validated());
       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truckWidth = TruckWidth::whereId($id)->first();
        $truckWidth->delete();
        return redirect()->route('admin.truck-widths.index')->with('success', 'Deleted');

    }
}
