<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Admin\TrucksRequest;
use App\Models\Truck;
use App\Models\TruckCategory;
use App\Models\TruckHeight;
use App\Models\TruckLength;
use App\Models\TruckLoadCapacity;
use App\Models\TruckModel;
use App\Models\TruckNumberOfAxles;
use App\Models\TruckType;
use App\Models\TruckWidth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;

class TrucksController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
//        abort_if(Gate::denies('all_suggestions'), 403);

        $trucks = Truck::where('added_by', 'admin')
            ->orderBy('created_at', 'desc')
            ->with(['type','catrgory','model','length','width','height','load_capacity','number_of_axles'])
            ->paginate();
        return view('admin.pages.trucks.index', compact('trucks'));

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $types=TruckType::all();
        $categories=TruckCategory::all();
        $models=TruckModel::all();
        $lengths=TruckLength::all();
        $widths=TruckWidth::all();
        $heights=TruckHeight::all();
        $load_capacitys=TruckLoadCapacity::all();
        $number_of_axless=TruckNumberOfAxles::all();
        return view('admin.pages.trucks.create',compact('types','categories','models','lengths','widths','heights','load_capacitys','number_of_axless'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(TrucksRequest $request)
    {
//        $flag = $request->file('flag');
//        $flag_name = time() . '-' . $flag->getClientOriginalName();
//        $flag->move(public_path() . '/images/flags/', $flag_name);
        Truck::create($request->validated());


        return redirect()->route('admin.trucks.index')->with('success', 'Added');
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $truck = Truck::whereId($id)->first();
        $types=TruckType::all();
        $categories=TruckCategory::all();
        $models=TruckModel::all();
        $lengths=TruckLength::all();
        $widths=TruckWidth::all();
        $heights=TruckHeight::all();
        $load_capacitys=TruckLoadCapacity::all();
        $number_of_axless=TruckNumberOfAxles::all();

        return view('admin.pages.trucks.edit', compact('truck','types','categories','models','lengths','widths','heights','load_capacitys','number_of_axless'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(TrucksRequest $request, $id)
    {
        $truck = Truck::whereId($id)->first();
        $truck->update($request->validated());

       return redirect()->back()->with('success', 'Updated');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
//        abort_if(Gate::denies('delete_suggestions'), 403);

        $truck = Truck::whereId($id)->first();
        $truck->delete();
        return redirect()->route('admin.trucks.index')->with('success', 'Deleted');

    }
}
