<?php

namespace App\Http\Controllers\Api\Drivers;

use App\Http\Controllers\Controller;
use App\Http\Requests\ChangePasswordRequest;
use App\Http\Requests\DriverProfileRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class DriverProfileController extends Controller
{
    public function update_profile(DriverProfileRequest $request)
    {
        try {
            $driver = auth('driver')->user();


            if($request->hasFile('profile_image')){

                $profile_image = $request->file('profile_image');
                $profile_image_name = Time().'-'.$profile_image->getClientOriginalName();
                $file_path = public_path().'/images/drivers';
                $profile_image->move($file_path,$profile_image_name);
            }


            if($driver){
                $driver->update([
                    'name' => $request->name,
                    'mobile'=> $request->mobile,
                    'identity_card_number' => $request->identity_card_number ? $request->identity_card_number : $driver->identity_card_number ,
                    'profile_image' => $request->hasFile('profile_image') ? $profile_image_name : $driver->profile_image
                ]);
            }
            return apiResponse(200 , 'profile is updated' , $driver);

          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }

    public function update_truck(Request $request)
    {
        try {

            $front_license_image = $request->file('front_license_image');
            $front_license_image_name = time() . '-' . $front_license_image->getClientOriginalName();
            $front_license_image->move(public_path().'/images/drivers/front_license_image/', $front_license_image_name);

            $back_license_image = $request->file('back_license_image');
            $back_license_image_name = time() . '-' . $back_license_image->getClientOriginalName();
            $back_license_image->move(public_path().'/images/drivers/back_license_image/', $back_license_image_name);

            $front_ownership_image = $request->file('front_ownership_image');
            $front_ownership_image_name = time() . '-' . $front_ownership_image->getClientOriginalName();
            $front_ownership_image->move(public_path().'/images/drivers/front_ownership_image/', $front_ownership_image_name);

            $back_ownership_image = $request->file('back_ownership_image');
            $back_ownership_image_name = time() . '-' . $back_ownership_image->getClientOriginalName();
            $back_ownership_image->move(public_path().'/images/drivers/back_ownership_image/', $back_ownership_image_name);

            $truck = auth('driver')->user()->truck;


            if($truck){
                $truck->update([
                    'number' => $request->number,
                    'color' => $request->color,
                    'type_id' => $request->type_id,
                    'catrgory_id' => $request->catrgory_id,
                    'model_id' => $request->model_id,
                    'length_id' => $request->length_id,
                    'width_id' => $request->width_id,
                    'height_id' => $request->height_id,
                    'load_capacity_id' => $request->load_capacity_id,
                    'number_of_axles_id' => $request->number_of_axles_id,
                    'front_license_image' => $front_license_image_name,
                    'back_license_image' => $back_license_image_name,
                    'front_ownership_image' => $front_ownership_image_name,
                    'back_ownership_image' => $back_ownership_image_name,
                ]);
            }
            return apiResponse(200 , 'truck is updated' , $truck);

          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }

    public function change_password(Request $request)
    {

        $driver = auth('driver')->user();

        if (Hash::check($request->old_password, $driver->password)) {

        if($request->password == $request->password_confirmation){

        if($request->password != $request->old_password){
           $driver->update([ 'password' => Hash::make($request->password)]);
           return apiResponse(200 ,'password is updated' , null);
        }
          else {
            return apiResponse(401, 'The Password And Old Password Must Be Different' , null);
        }
        } else {
            return apiResponse(401, 'The Password And Password Confirmation Does Not Match' , null);
        }
        } else {
            return apiResponse(401, 'Old Password Is Invalid' , null);
        }
    }




}
