<?php

namespace App\Http\Controllers\Api\Drivers;

use App\Http\Controllers\Controller;
use App\Http\Requests\RateRequest;
use App\Http\Resources\RateResource;

class DriverRateController extends Controller
{
    public function my_rates()
    {
        try {
            $driver = auth('driver')->user();
            return apiResponse(200 , null ,  RateResource::collection($driver->user_rates));
          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }


    public function add_rate(RateRequest $request)
    {
        try {
            $driver = auth('driver')->user();
            $driver->user_rates()->attach($request->user_id,['rate' => $request->rate]);
            return apiResponse(200 , 'rate is success' , RateResource::collection($driver->user_rates));
          } catch (\Throwable $th) {
            return apiResponse(404, $th->getMessage() , null);
          }
    }


}
