<?php

namespace App\Http\Requests\Admin;

use App\Helpers\Constant;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Password;

class RoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'          => [
                'required', 'string', 'max:190',
                Rule::unique('roles')
                ->whereNot('id', request()->role?request()->role->id:'')
            ],
            'permissions'   => ['required', 'array'],
        ];
    }
}
