<?php

namespace App\Http\Resources;

use App\Models\AppSetting;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use JsonSerializable;

class DriverShipmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array|Arrayable|JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'id' => $this->id,
            'reciever_name' => $this->receiver->name,
            'reciever_image' => asset('images/') . '/' . $this->receiver->image,
            'reciever_rate' => $this->receiver?->rate,
            'price' => $this->user_price ?? 0,
            'packing_from_name' => $this->from_address_details?->address_name . '(' . $this->from_address_details?->country?->name_ar . ')',
            'packing_from' => $this->from_address_details?->street_name . " - " . $this->from_address_details?->city?->name_ar . " - " . $this->from_address_details?->governorate?->name_ar . " - " . $this->from_address_details?->country?->name_ar,
            'packing_to_name' => $this->to_address_details?->address_name . '(' . $this->to_address_details->country?->name_ar . ')',
            'packing_to' => $this->to_address_details?->street_name . " - " . $this->to_address_details->city?->name_ar . " - " . $this->to_address_details->governorate?->name_ar . " - " . $this->to_address_details->country?->name_ar,
            'packing_date' => $this->packing_date . " - " . $this->packing_time,
            'driver_limit_price_percentage' => AppSetting::key('user_limit_price_percentage')->first()->value


        ];
    }
}


