<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class DriverUpdateResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'id' => $this->id,
            'truck' => new TruckResource($this->truck),
            'address' => new AddressResource($this->address),
            'front_license_image' => $this->front_license_image,
            'back_license_image' => $this->back_license_image,
            'front_ownership_image' => $this->front_ownership_image,
            'back_ownership_image' => $this->back_ownership_image,
            'address_id' => $this->address_id,
        ];
    }
}
