<?php

namespace App\Http\Resources;

use App\Models\FromAddress;
use Illuminate\Http\Resources\Json\JsonResource;

class ExportShipmentResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'id' => $this->id,
            'packing_date' => $this->packing_date,
            'sender_name' =>  $this->receiver->name,
            'sender_image' => asset('images/').'/'. $this->receiver->image,
            'sender_rate' => intval($this->receiver->rate),
            'count' => $this->count,
            'from_address_details'=>
            $request->header('language') == 'ar'  ?
            $this->from_address_details?->country->name_ar . " - " .
            ($this->from_address_details?->governorate ? $this->from_address_details->governorate->name_ar : '' ). " - " .
            $this->from_address_details?->city->name_ar . " - " .
            $this->from_address_details?->street_name  :
            $this->from_address_details?->country->name_en . " - " .
            ($this->from_address_details?->governorate ? $this->from_address_details?->governorate->name_en : '') . " - " .
            $this->from_address_details->city->name_en . " - " .
            $this->from_address_details?->street_name,
            'number_of trucks'=> $this->number_of_trucks,
            'address_name'=> $this->from_address_details?->address_name,
        ];
    }
}


