<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class GetDriverResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [

            'id' => $this->id,
            'name' => $this->name,
            'mobile' => $this->mobile,
            'profile_image' => asset('images/drivers/').'/'. $this->profile_image,
            'identity_type' => $this->identity_type,
            'identity_card_number' => $this->identity_card_number,
            'other_identity_type' => $this->other_identity_type,
            'front_identity_card_image' => asset('images/drivers/').'/'.  $this->front_identity_card_image,
            'back_identity_card_image' => asset('images/drivers/').'/'. $this->back_identity_card_image,
            'passport_image' => asset('images/drivers/').'/'. $this->passport_image,
            'other_identity_image' => asset('images/drivers/').'/'. $this->other_identity_image,
            'drivers_Count' => $this->drivers_Count,
            'number_of_trucks' => $this->number_of_trucks,
            'price' => $this->price,
            'rates' => $this->rates,
        ];
    }
}

