<?php

namespace App\Jobs;

use App\Events\SendOrderEvent;
use App\Events\SendShipmentEvent;
use App\Helpers\Constant;
use App\Models\Order;
use App\Models\OrderPendingProviders;
use App\Services\External\Notification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendShipmentToDrivers implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    protected $shipment ,$driver_id;
    public function __construct($shipment,$driver_id)
    {
        $this->shipment=$shipment;
        $this->driver_id=$driver_id;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {

        broadcast(new SendShipmentEvent($this->shipment,$this->driver_id));
        Notification::notify('drivers', 'shipments', [$this->driver_id], $this->shipment->id, 'new-shipment', 'new-shipment');



    }
}
