<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FromAddress extends Model
{
    use HasFactory;

    protected $fillable = [ 'latitude' , 'longitude','user_id'];

    public function country ()
    {
        return $this->belongsTo(ShipmentCountry::class , 'country_id' , 'id');
    }
    public function governorate ()
    {
        return $this->belongsTo(ShipmentGovernorate::class , 'governorate_id' , 'id');
    }
    public function city ()
    {
        return $this->belongsTo(ShipmentCity::class , 'city_id' , 'id');
    }
    
    public function from_address_details ()
    {
        return $this->hasOne(FromAddressDetail::class , 'from_address_id' , 'id');
    }
    
    
    
}
