<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
class Truck extends Model
{
    use HasFactory;

    protected $fillable = [
        'type_id' ,
        'number' ,
        'catrgory_id' ,
        'model_id' ,
        'color' ,
        'length_id',
        'width_id' ,
        'height_id' ,
        'load_capacity_id' ,
        'number_of_axles_id' ,
        'driver_id',
        'kilo_price',
        'added_by'
    ];


    public function type()
    {
        return $this->belongsTo(TruckType::class , 'type_id' ,'id');
    }

    public function catrgory()
    {
        return $this->belongsTo(TruckCategory::class , 'catrgory_id' ,'id');
    }

    public function model()
    {
        return $this->belongsTo(TruckModel::class , 'model_id' ,'id');
    }

    public function length()
    {
        return $this->belongsTo(TruckLength::class , 'length_id' ,'id');
    }

    public function width()
    {
        return $this->belongsTo(TruckWidth::class , 'width_id' ,'id');
    }

    public function height()
    {
        return $this->belongsTo(TruckHeight::class , 'height_id' ,'id');
    }

    public function load_capacity()
    {
        return $this->belongsTo(TruckLoadCapacity::class , 'load_capacity_id' ,'id');
    }

    public function number_of_axles()
    {
        return $this->belongsTo(TruckNumberOfAxles::class , 'number_of_axles_id' ,'id');
    }

    public function driver()
    {
        return $this->belongsTo(Driver::class , 'driver_id' ,'id');
    }
}
