<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('mobile')->unique();
            $table->string('verification_code')->nullable();
            $table->string('password');
            $table->string('rate')->nullable();
            $table->string('image')->nullable();
            $table->string('front_id_image')->nullable();
            $table->string('back_id_image')->nullable();
            $table->integer('forget_code')->nullable();
            $table->integer('country_id')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
