<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('drivers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('password');
            $table->string('mobile');
            $table->string('profile_image')->nullable();
            $table->enum('identity_type',['identity_card','passport','other'])->default('identity_card');
            $table->string('identity_card_number')->nullable();
            $table->string('front_identity_card_image')->nullable();
            $table->string('back_identity_card_image')->nullable();
            $table->string('passport_image')->nullable();
            $table->string('other_identity_type')->nullable();
            $table->string('front_license_image')->nullable();
            $table->string('back_license_image')->nullable();
            $table->string('front_ownership_image')->nullable();
            $table->string('back_ownership_image')->nullable();
            $table->string('other_identity_image')->nullable();
            $table->string('verification_code')->nullable();
            $table->integer('forget_code')->nullable();
            $table->integer('country_id')->nullable();
            $table->boolean('Stop_receiving_shipment_requests')->default(0);
            $table->integer('truck_id')->nullable();
            $table->integer('address_id')->nullable();
            $table->boolean('accepted')->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('drivers');
    }
};
