<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('shipment_drivers', function (Blueprint $table) {
            $table->integer('app_price')->after('price')->default(0);
            $table->integer('tax')->after('app_price')->default(0);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('shipment_drivers', function (Blueprint $table) {
            $table->dropColumn('app_price');
            $table->dropColumn('tax');
        });
    }
};
