<?php

namespace Database\Seeders;

use App\Models\Country;
use App\Models\Driver;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class MainSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Country::create([
            'name_ar' => 'مصر',
            'name_en' => 'egypt',
        ]);
        Country::create([
            'name_ar' => 'السعودية',
            'name_en' => 'ksa',
        ]);
        Country::create([
            'name_ar' => 'الامارات',
            'name_en' => 'uae',
        ]);

        User::create([
            'name' => 'user',
            'mobile' => '0101112131415',
            'password' => Hash::make(12345678),
            'country_id' => 1,
        ]);

        Driver::create([
            'name' => 'driver',
            'mobile' => '01011121314',
            'password' => Hash::make(12345678),
            'identity_type' => 'identity_card',
            'country_id' => 1,
        ]);
    }
}
