@extends('admin.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.drivers')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.drivers')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-sm-4">
                        </div>
                        <div class="col-sm-8">

                            {{--                            <div class="text-sm-end">--}}
                            {{--                                <button type="button" onclick="window.location='{{route('users.download')}}'"--}}
                            {{--                                        class="btn btn-success btn-rounded waves-effect waves-light mb-2 me-2"><i--}}
                            {{--                                        class="mdi mdi-microsoft-excel me-1"></i> {{__('admin.download-excel')}}--}}
                            {{--                                </button>--}}
                            {{--                            </div>--}}
                        </div><!-- end col-->
                    </div>
                    <form method="get" action="{{route('admin.drivers.index')}}">
                        <div class="row">

                            <div class="col-md-5">
                                <div class="mb-3">
                                    <label for="formrow-email-input"
                                           class="form-label">{{__('admin.from-date')}}</label>
                                    <input name="from" class="form-control" type="date"
                                           value="{{old('from')??request('from')}}"
                                           id="example-date-input">
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="mb-3">
                                    <label for="formrow-password-input"
                                           class="form-label">{{__('admin.to-date')}}</label>
                                    <input name="to" class="form-control" type="date"
                                           value="{{old('to')??request('to')}}"
                                           id="example-date-input">
                                </div>
                            </div>
                            <div class="col-md-2 ">
                                <div class="d-grid">
                                    <label for="formrow-email-input"
                                           class="form-label hidden">{{__('admin.search')}}</label>
                                    <input data-repeater-delete="" type="submit"
                                           class="btn btn-primary inner" value="{{__('admin.search')}}">
                                </div>
                            </div>
                        </div>
                    </form>

                    <div class="table-responsive mt-2">
                        <table class="table table-hover  dt-responsive nowrap"
                               style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr class="tr-colored">
                                <th scope="col">{{__('admin.id')}}</th>
                                <th scope="col">{{__('admin.img')}}</th>

                                <th scope="col">{{__('admin.name')}}</th>
                                <th scope="col">{{__('admin.phone')}}</th>
                                <th scope="col">{{__('admin.identity_type')}}</th>
                                <th scope="col">{{__('admin.identity_card_number')}}</th>
                                <th scope="col">{{__('admin.front_identity_card_image')}}</th>
                                <th scope="col">{{__('admin.back_identity_card_image')}}</th>
                                {{--                                <th scope="col">{{__('admin.other_identity_type')}}</th>--}}
                                <th scope="col">{{__('admin.other_identity_image')}}</th>

                                <th scope="col">{{__('admin.passport_image')}}</th>
                                <th scope="col">{{__('admin.front_license_image')}}</th>
                                <th scope="col">{{__('admin.back_license_image')}}</th>
                                <th scope="col">{{__('admin.front_ownership_image')}}</th>
                                <th scope="col">{{__('admin.back_ownership_image')}}</th>
                                <th scope="col">{{__('admin.country')}}</th>
                                <th scope="col">{{__('admin.truck')}}</th>
                                <th scope="col">{{__('admin.address')}}</th>
                                {{--                                <th scope="col">{{__('admin.status')}}</th>--}}
                                <th scope="col">{{__('admin.created_at')}}</th>
                                <th scope="col">{{__('admin.more')}}</th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach($drivers as $driver)

                                <tr @if($driver->status==2) style=" background: #f38e8e;" @endif>
                                    <td>{{$driver->id}}</td>
                                    <td>
                                        <a href="{{asset('images/drivers/'.$driver->profile_image)}}" target="_blank"
                                           class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/'.$driver->profile_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>

                                    <td>{{$driver->name??'-'}}</td>
                                    <td style="direction: ltr;"><a
                                            href="tel:{{$driver->mobile}}"> {{$driver->mobile}} </a></td>
                                    {{--                                    <td>--}}
                                    {{--                                        <div class="form-check form-switch form-switch-lg mb-3" dir="ltr">--}}
                                    {{--                                            <input class="form-check-input" type="checkbox"--}}
                                    {{--                                                   onchange="return window.location.href = '{{route('admin.users.change-status',$user->id)}}'"--}}
                                    {{--                                                   @if($user->verified==3)checked="" @endif>--}}

                                    {{--                                        </div>--}}
                                    {{--                                    </td>--}}
                                    <td>{{__('admin.'.$driver->identity_type)}}</td>
                                    <td>{{$driver->identity_card_number??'-'}}</td>

                                    <td>
                                        <a href="{{asset('images/drivers/front_identity_card_image/'.$driver->front_identity_card_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/front_identity_card_image/'.$driver->front_identity_card_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{asset('images/drivers/back_identity_card_image/'.$driver->back_identity_card_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/back_identity_card_image/'.$driver->back_identity_card_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>
                                    {{--                                    <td>{{$driver->other_identity_type??'-'}}</td>--}}

                                    <td>
                                        <a href="{{asset('images/drivers/other_identity_image/'.$driver->other_identity_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/other_identity_image/'.$driver->other_identity_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>

                                    <td>
                                        <a href="{{asset('images/drivers/passport_image/'.$driver->passport_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/passport_image/'.$driver->passport_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>

                                    <td>
                                        <a href="{{asset('images/drivers/front_license_image/'.$driver->front_license_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/front_license_image/'.$driver->front_license_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>

                                    <td>
                                        <a href="{{asset('images/drivers/back_license_image/'.$driver->back_license_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/back_license_image/'.$driver->back_license_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>

                                    <td>
                                        <a href="{{asset('images/drivers/front_ownership_image/'.$driver->front_ownership_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/front_ownership_image/'.$driver->front_ownership_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>
                                    <td>
                                        <a href="{{asset('images/drivers/back_ownership_image/'.$driver->back_ownership_image)}}"
                                           target="_blank" class="text-body fw-bold">

                                            <img class="rounded-circle header-profile-user"
                                                 src="{{asset('images/drivers/back_ownership_image/'.$driver->back_ownership_image)}}"
                                                 alt="Header Avatar">
                                        </a>
                                    </td>
                                    <td>{{$driver->country?->name_ar}}</td>
                                    <td>{{$driver->truck? $driver->truck->type?->type_ar : ''}}</td>
                                    <td>
                                        <a target="_blank"
                                           href="https://maps.google.com/maps/search/?q={{$driver->address?->latitude}},{{$driver->address?->longitude}}&hl=es&z=14&output=embed">
                                            {{__('admin.location')}}
                                        </a>

                                    </td>


                                    <td>
                                        {{Carbon\Carbon::parse($driver->created_at)->locale('ar')->translatedFormat('l dS F G:i - Y')}}
                                    </td>
                                    <td>
                                        <div class="d-flex gap-3">
                                            @can('edit_drivers')

                                                <a href="{{route('admin.drivers.edit',$driver->id)}}"
                                                   title="{{__('admin.edit')}}" class="text-success"><i
                                                        class="mdi mdi-pen-plus font-size-18"></i></a>
                                            @endcan
                                            @can('access_drivers')

                                                <a href="{{route('admin.shipments.index',['driver_id'=>$driver->id])}}"
                                                   title="{{__('admin.shipments')}}" class="text-dark"><i
                                                        class="mdi mdi-truck-check font-size-18"></i></a>
                                            @endcan
                                            @can('access_drivers')

                                                <a href="{{route('admin.drivers.rates',$driver->id)}}"
                                                   title="{{__('admin.rates')}}" class="text-dark"><i
                                                        class="mdi mdi-star-box font-size-18"></i></a>
                                            @endcan
                                            @can('edit_drivers')

                                                <a href="{{route('admin.drivers.status',$driver->id)}}"
                                                   title="{{__('admin.status')}}"
                                                   @if($driver->status==1) class="text-success"
                                                   @else class="text-danger" @endif><i
                                                        class="mdi @if($driver->status==2) mdi-account-alert @else mdi-account @endif font-size-18"></i></a>
                                            @endcan
                                            @can('delete_drivers')

                                                <a onclick="openModalDelete({{$driver->id}})"
                                                   title="{{__('admin.delete')}}" class="text-danger"><i
                                                        class="mdi mdi-delete font-size-18"></i></a>
                                            @endcan


                                        </div>
                                    </td>
                                </tr>
                            @endforeach


                            </tbody>
                        </table>

                    </div>
                    {{$drivers->withQueryString()->links('admin.pagination.bootstrap-4')}}

                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>

    <script src="{{asset('admin_assets/js/jquery.printPage.js') }}"></script>

    <script>
        function openModalDelete(driver_id) {
            $('.action_form').attr('action', '{{route('admin.drivers.destroy', '')}}' + '/' + driver_id);
            $('#deleteModal').modal('show');
        }
    </script>



@endsection
@section('modal')

    @component('admin.layouts.includes.modal')
        @slot('modalID')
            deleteModal
        @endslot
        @slot('modalTitle')
            {{__('admin.delete-data')}}
        @endslot
        @slot('modalMethodPutOrDelete')
            @method('delete')
        @endslot
        @slot('modalContent')
            <div class="text-center">
                <span class="text-danger font-16">
                    {{__('admin.delete-message-confirm')}}
                </span>
            </div>
        @endslot
    @endcomponent
@endsection
