@extends('admin.layouts.app')
@section('extra-css')
    <link href="{{ asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css') }}" id="bootstrap-style"
        rel="stylesheet" type="text/css" />
    <link href="{{ asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css') }}"
        id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="{{ asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css') }}"
        id="bootstrap-style" rel="stylesheet" type="text/css" />
@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{ __('admin.notifications') }}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{ __('admin.Dashboard') }}</a>
                        </li>
                        <li class="breadcrumb-item active">{{ __('admin.notifications') }}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i
                                    class="icon-thumb-down"></i>

                                <p>{{ $error }}</p>
                                <button class="close" type="button" data-dismiss="alert" aria-label="Close"
                                    data-original-title="" title=""><span aria-hidden="true">×</span></button>

                            </div>
                        @endforeach
                    @endif
                    <div class="crypto-buy-sell-nav">


{{--                        <ul class="nav nav-tabs nav-tabs-custom" role="tablist">--}}
{{--                            <li class="nav-item">--}}
{{--                                <a class="nav-link active" data-bs-toggle="tab" href="#buy" role="tab">--}}
{{--                                    عربي--}}
{{--                                </a>--}}
{{--                            </li>--}}
{{--                            <li class="nav-item">--}}
{{--                                <a class="nav-link" data-bs-toggle="tab" href="#sell" role="tab">--}}
{{--                                    English--}}
{{--                                </a>--}}
{{--                            </li>--}}
{{--                        </ul>--}}



                        <form action="{{ route('admin.notifications.store') }}" method="post"
                            enctype="multipart/form-data">

                            @csrf

                            <div class="tab-content">
                                <!-- Tab Pane for Arabic -->
                                <div class="tab-pane fade show active" id="buy" role="tabpanel">
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="mb-3">
                                                <label for="formrow-title-ar" class="form-label">
                                                    {{ __('admin.title-field') }}
                                                </label>
                                                <input type="text" name="title_ar" value="{{ old('title_ar') }}" required
                                                    class="form-control" id="formrow-title-ar"
                                                    placeholder="{{ __('admin.title-field') }}">
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="mb-3">
                                                <label for="formrow-description-ar" class="form-label">
                                                    {{ __('admin.description') }}
                                                </label>
                                                <textarea class="form-control" id="formrow-description-ar" rows="5" required name="body_ar"
                                                    placeholder="{{ __('admin.description') }}">{{ old('body_ar') }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tab Pane for English -->
{{--                                <div class="tab-pane fade" id="sell" role="tabpanel">--}}
{{--                                    <div class="row">--}}
{{--                                        <div class="col-sm-12">--}}
{{--                                            <div class="mb-3">--}}
{{--                                                <label for="formrow-title-en" class="form-label">--}}
{{--                                                    {{ __('admin.title-field') }}--}}
{{--                                                </label>--}}
{{--                                                <input type="text" name="title_en" value="{{ old('title_en') }}" required--}}
{{--                                                    class="form-control" id="formrow-title-en"--}}
{{--                                                    placeholder="{{ __('admin.title-field') }}">--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                        <div class="col-sm-12">--}}
{{--                                            <div class="mb-3">--}}
{{--                                                <label for="formrow-description-en" class="form-label">--}}
{{--                                                    {{ __('admin.description') }}--}}
{{--                                                </label>--}}
{{--                                                <textarea class="form-control" id="formrow-description-en" rows="5" required name="body_en"--}}
{{--                                                    placeholder="{{ __('admin.description') }}">{{ old('body_en') }}</textarea>--}}
{{--                                            </div>--}}
{{--                                        </div>--}}
{{--                                    </div>--}}
{{--                                </div>--}}
                            </div>

                            <div class="row">
                                <div class="mb-3">
                                    <label for="user_type" class="form-label"> {{ __('admin.user_type') }} </label>
                                    <select id="user_type" onchange="chooseUsersOrDrivers()" class="form-select"
                                        name="user_type">
                                        <option selected="" disabled> {{ __('admin.user_type') }}</option>
                                        <option value="users">{{ __('admin.all-users') }}</option>
                                        <option value="drivers">{{ __('admin.all-drivers') }}</option>
                                        <option value="user">{{ __('admin.user') }}</option>
                                        <option value="driver">{{ __('admin.driver') }}</option>
                                    </select>
                                </div>

                            </div>
                            <div class="row" id="users" style="display: none;">
                                <div class="mb-3">
                                    <label for="user_id" class="form-label"> {{ __('admin.users') }} </label>
                                    <select id="user_id" class="form-select" name="user_id">
                                        <option selected="" disabled> {{ __('admin.users') }}</option>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>
                            <div class="row" id="drivers" style="display: none;">
                                <div class="mb-3">
                                    <label for="driver_id" class="form-label"> {{ __('admin.drivers') }} </label>
                                    <select id="driver_id" class="form-select" name="driver_id">
                                        <option selected="" disabled> {{ __('admin.drivers') }}</option>
                                        @foreach ($drivers as $driver)
                                            <option value="{{ $driver->id }}">{{ $driver->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            <div class="d-flex flex-wrap gap-2">
                                <button type="submit" class="btn btn-primary waves-effect waves-light">
                                    {{ __('admin.add') }}</button>

                            </div>

                        </form>

                    </div>
                </div>
            </div>


        </div>
    </div>

    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{ asset('admin_assets/libs/select2/js/select2.min.js') }}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{ asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js') }}"></script>

    <!-- Required datatable js -->
    <script src="{{ asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js') }}"></script>

    <!-- Responsive examples -->
    <script src="{{ asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js') }}"></script>

    <!-- init js -->
    <script src="{{ asset('admin_assets/js/pages/crypto-orders.init.js') }}"></script>
    <script>
        function chooseUsersOrDrivers() {
            let choosedType = $('#user_type').val();
            if (choosedType == 'user') {
                $('#users').css('display', 'block');
                $('#user_id').css('display', 'block');
                $('#driver_id').css('display', 'none');
                $('#drivers').css('display', 'none');
            } else if (choosedType == 'driver') {
                $('#driver_id').css('display', 'block');
                $('#drivers').css('display', 'block');
                $('#user_id').css('display', 'none');
                $('#users').css('display', 'none');

            }


        }
    </script>
@endsection
