@extends('admin.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.trucks')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.trucks')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i
                                    class="icon-thumb-down"></i>

                                <p>{{ $error }}</p>
                                <button class="close" type="button" data-dismiss="alert" aria-label="Close"
                                        data-original-title="" title=""><span aria-hidden="true">×</span></button>

                            </div>

                        @endforeach
                    @endif
                    <div class="crypto-buy-sell-nav">

{{--                        <ul class="nav nav-tabs nav-tabs-custom" role="tablist">--}}
{{--                            <li class="nav-item">--}}
{{--                                <a class="nav-link active show" data-bs-toggle="tab" href="#buy" role="tab">--}}
{{--                                    عربي--}}
{{--                                </a>--}}
{{--                            </li>--}}
{{--                            <li class="nav-item">--}}
{{--                                <a class="nav-link" data-bs-toggle="tab" href="#sell" role="tab">--}}
{{--                                    English--}}
{{--                                </a>--}}
{{--                            </li>--}}
{{--                        </ul>--}}

                        <form action="{{route('admin.trucks.store')}}" method="post" enctype="multipart/form-data">

                            <input type="text" hidden name="added_by" value="admin">
                            <div class="tab-content crypto-buy-sell-nav-content p-4">
                                @csrf
                                <div class="tab-pane active" id="buy" role="tabpanel">
                                    <div class="row">


                                        <div class="col-sm-12">


                                            <div class="mb-3">
                                                <label for="number"
                                                       class="form-label">   {{__('admin.number')}}  </label>
                                                <input type="text" name="number" value="{{old('number')}}" required
                                                       class="form-control" id="number"
                                                       placeholder="{{__('admin.number')}}">
                                            </div>

                                        </div>
                                    </div>
                                    <div class="row">


                                        <div class="col-sm-12">


                                            <div class="mb-3">
                                                <label for="color"
                                                       class="form-label">   {{__('admin.color')}}  </label>
                                                <input type="text" name="color" value="{{old('color')}}" required
                                                       class="form-control" id="color"
                                                       placeholder="{{__('admin.color')}}">
                                            </div>

                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.types')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="type_id">
                                                <option selected="" disabled> {{__('admin.types')}}</option>
                                                @foreach($types as $type)
                                                    <option value="{{$type->id}}">{{$type->type_ar}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.categories')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="catrgory_id">
                                                <option selected="" disabled> {{__('admin.categories')}}</option>
                                                @foreach($categories as $category)
                                                    <option value="{{$category->id}}">{{$category->category_ar}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.models')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="model_id">
                                                <option selected="" disabled> {{__('admin.models')}}</option>
                                                @foreach($models as $model)
                                                    <option value="{{$model->id}}">{{$model->model}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.lengths')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="length_id">
                                                <option selected="" disabled> {{__('admin.lengths')}}</option>
                                                @foreach($lengths as $length)
                                                    <option value="{{$length->id}}">{{$length->length}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.widths')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="width_id">
                                                <option selected="" disabled> {{__('admin.widths')}}</option>
                                                @foreach($widths as $width)
                                                    <option value="{{$width->id}}">{{$width->width}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.heights')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="height_id">
                                                <option selected="" disabled> {{__('admin.heights')}}</option>
                                                @foreach($heights as $height)
                                                    <option value="{{$height->id}}">{{$height->height}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.load_capacity')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="load_capacity_id">
                                                <option selected="" disabled> {{__('admin.load_capacity')}}</option>
                                                @foreach($load_capacitys as $load_capacity)
                                                    <option value="{{$load_capacity->id}}">{{$load_capacity->load_capacity}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="mb-3">
                                            <label for="formrow-inputState"
                                                   class="form-label">     {{__('admin.number_of_axles')}}  </label>
                                            <select id="formrow-inputState" class="form-select" name="number_of_axles_id">
                                                <option selected="" disabled> {{__('admin.number_of_axles')}}</option>
                                                @foreach($number_of_axless as $number_of_axles)
                                                    <option value="{{$number_of_axles->id}}">{{$number_of_axles->number_of_axles}}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="col-sm-12">


                                            <div class="mb-3">
                                                <label for="number"
                                                       class="form-label">   {{__('admin.kilo_price')}}  </label>
                                                <input type="text" name="kilo_price" value="{{old('kilo_price')}}" required
                                                       class="form-control" id="number"
                                                       placeholder="{{__('admin.kilo_price')}}">
                                            </div>

                                        </div>
                                </div>
{{--                                <div class="tab-pane" id="sell" role="tabpanel">--}}
{{--                                    <div class="row">--}}


{{--                                        <div class="col-sm-12">--}}


{{--                                            <div class="mb-3">--}}
{{--                                                <label for="formrow-firstname-input"--}}
{{--                                                       class="form-label">   {{__('admin.english-name')}}  </label>--}}
{{--                                                <input type="text" name="name_en" value="{{old('name_en')}}" required--}}
{{--                                                       class="form-control" id="formrow-firstname-input"--}}
{{--                                                       placeholder="{{__('admin.english-name')}}">--}}
{{--                                            </div>--}}

{{--                                        </div>--}}
{{--                                    </div>--}}

{{--                                </div>--}}
                                <div class="d-flex flex-wrap gap-2">
                                    <button type="submit"
                                            class="btn btn-primary waves-effect waves-light"> {{__('admin.add')}}</button>

                                </div>


                            </div>

                        </form>

                    </div>
                </div>
            </div>


        </div>
    </div>

    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>


@endsection
