@extends('admin.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.users')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.users')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-sm-4">
                        </div>
                        <div class="col-sm-8">

{{--                            <div class="text-sm-end">--}}
{{--                                <button type="button" onclick="window.location='{{route('users.download')}}'"--}}
{{--                                        class="btn btn-success btn-rounded waves-effect waves-light mb-2 me-2"><i--}}
{{--                                        class="mdi mdi-microsoft-excel me-1"></i> {{__('admin.download-excel')}}--}}
{{--                                </button>--}}
{{--                            </div>--}}
                        </div><!-- end col-->
                    </div>
                    <form  method="get" action="{{route('admin.users.index')}}">
                        <div class="row">

                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label
                                           class="form-label">{{__('admin.search-by-id')}}</label>
                                    <input name="id" class="form-control" type="text" value="{{old('id')??request('id')}}"
                                         >
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="mb-3">
                                    <label
                                           class="form-label">{{__('admin.search')}}</label>
                                    <input name="search" class="form-control" type="text" value="{{old('search')??request('search')}}"
                                         >
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="formrow-email-input"
                                           class="form-label">{{__('admin.from-date')}}</label>
                                    <input name="from" class="form-control" type="date" value="{{old('from')??request('from')}}"
                                           id="example-date-input">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="mb-3">
                                    <label for="formrow-password-input"
                                           class="form-label">{{__('admin.to-date')}}</label>
                                    <input name="to" class="form-control" type="date" value="{{old('to')??request('to')}}"
                                           id="example-date-input">
                                </div>
                            </div>
                            <div class="col-md-2 ">
                                <div class="d-grid">
                                    <label for="formrow-email-input"
                                           class="form-label hidden">{{__('admin.search')}}</label>
                                    <input data-repeater-delete="" type="submit"
                                           class="btn btn-primary inner" value="{{__('admin.search')}}">
                                </div>
                            </div>
                        </div>
                    </form>
                    <div class="table-responsive mt-2">
                        <table class="table table-hover  dt-responsive nowrap"
                               style="border-collapse: collapse; border-spacing: 0; width: 100%;">
                            <thead>
                            <tr class="tr-colored">
                                <th scope="col">{{__('admin.id')}}</th>
                                <th scope="col">{{__('admin.img')}}</th>

                                <th scope="col">{{__('admin.name')}}</th>
                                <th scope="col">{{__('admin.phone')}}</th>
{{--                                <th scope="col">{{__('admin.status')}}</th>--}}
                                <th scope="col">{{__('admin.created_at')}}</th>
                                <th scope="col">{{__('admin.more')}}</th>

                            </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)

                                <tr @if($user->status==2) style=" background: #f38e8e;" @endif>
                                    <td>{{$user->id}}/td>
                                    <td>
                                        <a href="{{$user->image?asset('images/').'/'. $user->image:asset('admin_assets/images/users/user.png')}}" target="_blank" class="text-body fw-bold">

                                        <img class="rounded-circle header-profile-user" src="{{$user->image?asset('images/').'/'. $user->image:asset('admin_assets/images/users/user.png')}}"
                                             alt="Header Avatar">
                                        </a>
                                    </td>

                                    <td>{{$user->name}}</td>
                                    <td style="direction: ltr;"><a href="tel:{{$user->mobile}}"> {{$user->mobile}} </a></td>
{{--                                    <td>--}}
{{--                                        <div class="form-check form-switch form-switch-lg mb-3" dir="ltr">--}}
{{--                                            <input class="form-check-input" type="checkbox"--}}
{{--                                                   onchange="return window.location.href = '{{route('admin.users.change-status',$user->id)}}'"--}}
{{--                                                   @if($user->verified==3)checked="" @endif>--}}

{{--                                        </div>--}}
{{--                                    </td>--}}

                                    <td>
                                        {{Carbon\Carbon::parse($user->created_at)->locale('ar')->translatedFormat('l dS F G:i - Y')}}
                                    </td>
                                    <td>
                                        <div class="d-flex gap-3">
                                            @can('edit_users')

                                                <a href="{{route('admin.users.edit',$user->id)}}" title="{{__('admin.edit')}}" class="text-success"><i
                                                        class="mdi mdi-pen-plus font-size-18"></i></a>
                                            @endcan
                                                @can('access_shipments_users')


                                                <a href="{{route('admin.shipments.index',['user_id'=>$user->id])}}" title="{{__('admin.shipments')}}" class="text-dark"><i
                                                        class="mdi mdi-truck-check font-size-18"></i></a>
                                                @endcan
                                                @can('update_status_users')

                                                <a href="{{route('admin.users.status',$user->id)}}" title="{{__('admin.status')}}"  @if($user->status==1) class="text-success" @else class="text-danger" @endif><i
                                                        class="mdi @if($user->status==2) mdi-account-alert @else mdi-account @endif font-size-18"></i></a>
                                                @endcan
                                                @can('delete_users')


                                                <a onclick="openModalDelete({{$user->id}})" title="{{__('admin.delete')}}" class="text-danger"><i
                                                        class="mdi mdi-delete font-size-18"></i></a>
                                                @endcan

                                        </div>
                                    </td>
                                </tr>
                            @endforeach


                            </tbody>
                        </table>

                    </div>
                    {{$users->withQueryString()->links('admin.pagination.bootstrap-4')}}

                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>

    <script src="{{asset('admin_assets/js/jquery.printPage.js') }}"></script>

    <script>
        function openModalDelete(user_id) {
            $('.action_form').attr('action', '{{route('admin.users.destroy', '')}}' + '/' + user_id);
            $('#deleteModal').modal('show');
        }
    </script>



@endsection
@section('modal')
@component('admin.layouts.includes.modal')
    @slot('modalID')
        deleteModal
    @endslot
    @slot('modalTitle')
        {{__('admin.delete-data')}}
    @endslot
    @slot('modalMethodPutOrDelete')
        @method('delete')
    @endslot
    @slot('modalContent')
        <div class="text-center">
                <span class="text-danger font-16">
                    {{__('admin.delete-message-confirm')}}
                </span>
        </div>
    @endslot
@endcomponent
@endsection
