@extends('shipper.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.drivers')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.drivers')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    @if ($errors->any())
                        @foreach ($errors->all() as $error)
                            <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i
                                    class="icon-thumb-down"></i>

                                <p>{{ $error }}</p>
                                <button class="close" type="button" data-dismiss="alert" aria-label="Close"
                                        data-original-title="" title=""><span aria-hidden="true">×</span></button>

                            </div>

                        @endforeach
                    @endif


                    <form action="{{route('shipper.drivers.update',$driver->id)}}" method="post"
                          enctype="multipart/form-data">
                        @csrf
                        @method('patch')
                        <input type="hidden" name="updateuser" value="1">

                        <div class="row">


                            <div class="col-sm-12">


                                <div class="mb-3">
                                    <label for="formrow-firstname-input"
                                           class="form-label">   {{__('admin.name')}}  </label>
                                    <input type="text" required name="name" value="{{$driver->name??''}}"
                                           autocomplete="off" class="form-control" id="formrow-firstname-input"
                                           placeholder="{{__('admin.name')}}">
                                </div>

                                <div class="mb-3">
                                    <label for="password" class="form-label">    {{__('admin.password')}}  </label>
                                    <input class="form-control" name="password" type="password" id="password">
                                </div>
                                <div class="mb-3">
                                    <label for="mobile" class="form-label">    {{__('admin.phone')}}  </label>
                                    <input class="form-control"  name="mobile" value="{{$driver->mobile}}"
                                           type="number" id="mobile">
                                </div>
                                <div class="mb-3">
                                    <div class="input-box">
                                        <label for="country_id">{{__('admin.country')}}</label>
                                        <select class="form-select form-control" name="country_id" id="country_id" required>
                                            <option selected disabled value="">{{__('admin.choose-country')}}</option>
                                            @if(count($countries)>0)
                                                @foreach($countries as $country)
                                                    <option @if($driver->country_id==$country->id) selected @endif value="{{$country->id}}">{{$country->name_ar}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <div class="input-box">
                                        <label for="country_id">{{__('admin.trucks')}}</label>
                                        <select class="form-select form-control" name="truck_id" id="truck_id" required>
                                            <option selected disabled value="">{{__('admin.choose-truck')}}</option>
                                            @if(count($trucks)>0)
                                                @foreach($trucks as $truck)
                                                    <option @if($driver->truck_id==$truck->id) selected @endif  value="{{$truck->id}}">{{$truck->type->type_ar}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <div class="input-box">
                                        <label for="identity_type">{{__('admin.identity_type')}}</label>
                                        <select class="form-select form-control" name="identity_type" id="identity_type" required>
                                            <option selected disabled
                                                    value="">{{__('admin.choose-identity_type')}}</option>
                                            <option value="identity_card" @if($driver->identity_type=='identity_card') selected @endif>{{__('admin.identity_card')}}</option>
                                            <option value="passport" @if($driver->identity_type=='passport') selected @endif>{{__('admin.passport')}}</option>
                                            <option value="other"  @if($driver->identity_type=='other') selected @endif>{{__('admin.other')}}</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="mb-3">
                                    <label for="identity_card_number"
                                           class="form-label">    {{__('admin.identity_card_number')}}  </label>
                                    <input class="form-control" name="identity_card_number"
                                           value="{{$driver->identity_card_number}}" type="number"
                                           id="identity_card_number">
                                </div>


                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.img')}}  </label>
                            <input class="form-control" type="file" name="profile_image" id="formFile">
                        </div>

                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/'.$driver->profile_image) }}">
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.front_identity_card_image')}}  </label>
                            <input class="form-control" type="file" name="front_identity_card_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/front_identity_card_image/'.$driver->front_identity_card_image) }}">
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.back_identity_card_image')}}  </label>
                            <input class="form-control" type="file" name="back_identity_card_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/back_identity_card_image/'.$driver->back_identity_card_image) }}">
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.passport_image')}}  </label>
                            <input class="form-control" type="file" name="passport_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/passport_image/'.$driver->passport_image) }}">
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.other_identity_image')}}  </label>
                            <input class="form-control" type="file" name="other_identity_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/other_identity_image/'.$driver->other_identity_image) }}">
                        </div>



                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.front_license_image')}}  </label>
                            <input class="form-control" type="file" name="front_license_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/front_license_image/'.$driver->front_license_image) }}">
                        </div>



                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.back_license_image')}}  </label>
                            <input class="form-control" type="file" name="back_license_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/front_license_image/'.$driver->back_license_image) }}">
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.front_ownership_image')}}  </label>
                            <input class="form-control" type="file" name="front_ownership_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/front_ownership_image/'.$driver->front_ownership_image) }}">
                        </div>

                        <div class="mb-3">
                            <label for="formrow-firstname-input" class="form-label">    {{__('admin.back_ownership_image')}}  </label>
                            <input class="form-control" type="file" name="back_ownership_image" id="formFile">
                        </div>
                        <div class="col-lg-3">
                            <img style="width: 150px;height: 150px;padding-bottom: 15px;"
                                 src="{{asset('images/drivers/back_ownership_image/'.$driver->back_ownership_image) }}">
                        </div>



                        <div class="d-flex flex-wrap gap-2">
                            <button type="submit"
                                    class="btn btn-primary waves-effect waves-light"> {{__('admin.update')}}</button>

                        </div>

                    </form>

                </div>
            </div>


        </div>
    </div>

    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>


@endsection
