@extends('shipper.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.roles')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.roles')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <!-- start page title -->
    <!-- end page title -->

    <div class="row">
        <div class="col-12">
            <form action="{{route('shipper.roles.store')}}" method="post" enctype="multipart/form-data">
                @csrf
            <div class="card">
                <div class="card-body">
                    <div class="row">


                        <div class="col-sm-12">


                            <div class="mb-3">
                                <label for="formrow-firstname-input"
                                       class="form-label">   {{__('admin.role_name')}}  </label>
                                <input type="text" class="form-control" name="name" required
                                       id="formrow-firstname-input"
                                       placeholder="{{__('admin.please-enter-role-name')}}">
                            </div>


                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">{{__('admin.permissions')}}</h4>
                    <div class="form-check mb-4">
                        <input class="form-check-input custom-checkbox" type="checkbox" id="select-all"
                               name="select-all">
                        <label class="form-check-label mt-4px" for="select-all">
                            {{__('admin.give_all_permissions')}}
                        </label>


                    </div>

                    <div class="row">


                        <div class="col-xl-3 col-sm-6">
                            <div class="mt-4 mt-xl-0">
                                <h4 class="font-size-14 mb-3">{{__('admin.statistics')}}</h4>
                                <div class="docs-toggles">
                                    <ul class="list-group">
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" id="access_statistics"
                                                       name="permissions[]"
                                                       value="access_statistics" {{ old('access_statistics') ? 'checked' : '' }}>
                                                <label for="access_statistics"
                                                       class="form-check-label">{{__('admin.access_statistics')}}</label>

                                            </div>
                                        </li>


                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6">
                            <div class="mt-4 mt-xl-0">
                                <h4 class="font-size-14 mb-3">{{__('admin.shipments')}}</h4>
                                <div class="docs-toggles">
                                    <ul class="list-group">
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="access_shipments" type="checkbox"
                                                       name="permissions[]"
                                                       value="access_shipments" {{ old('access_shipments') ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                       for="access_shipments">{{__('admin.access_shipments')}}</label>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="edit_shipments" type="checkbox"
                                                       name="permissions[]"
                                                       value="edit_shipments" {{ old('edit_shipments') ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                       for="edit_shipments">{{__('admin.edit_shipments')}}</label>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="delete_shipments" type="checkbox"
                                                       name="permissions[]"
                                                       value="delete_shipments" {{ old('delete_shipments') ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                       for="delete_shipments">{{__('admin.delete_shipments')}}</label>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-3 col-sm-6">
                            <div class="mt-4 mt-xl-0">
                                <h4 class="font-size-14 mb-3">{{__('admin.drivers')}}</h4>
                                <div class="docs-toggles">
                                    <ul class="list-group">
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="access_drivers" type="checkbox"
                                                       name="permissions[]"
                                                       value="access_drivers" {{ old('access_drivers') ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                       for="access_drivers">{{__('admin.access_drivers')}}</label>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="create_drivers" type="checkbox"
                                                       name="permissions[]"
                                                       value="create_drivers" {{ old('create_drivers') ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                       for="create_drivers">{{__('admin.create_drivers')}}</label>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="edit_drivers" type="checkbox"
                                                       name="permissions[]"
                                                       value="edit_drivers" {{ old('edit_drivers') ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                       for="edit_drivers">{{__('admin.edit_drivers')}}</label>
                                            </div>
                                        </li>
                                        <li class="list-group-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="delete_drivers" type="checkbox"
                                                       name="permissions[]"
                                                       value="delete_drivers" {{ old('delete_drivers') ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                       for="delete_drivers">{{__('admin.delete_drivers')}}</label>
                                            </div>
                                        </li>

                                    </ul>
                                </div>
                            </div>
                        </div>


                    </div>

                </div>

                <div class="d-flex flex-wrap gap-2 mt-3">
                    <button type="submit"
                            class="btn btn-primary waves-effect waves-light"> {{__('admin.add')}}  </button>

                </div>

            </div>


            </form>

        </div>

    </div>
    </div>
    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('#select-all').click(function () {
                var checked = this.checked;
                $('input[type="checkbox"]').each(function () {
                    this.checked = checked;
                });
            })
        });
    </script>

@endsection
