@extends('shipper.layouts.app')
@section('extra-css')
    <link href="{{asset('admin_assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-buttons-bs4/css/buttons.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>
    <link href="{{asset('admin_assets/libs/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}"
          id="bootstrap-style" rel="stylesheet"
          type="text/css"/>

@endsection
@section('content')

    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{__('admin.shipments')}}</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">{{__('admin.Dashboard')}}</a>
                        </li>
                        <li class="breadcrumb-item active">{{__('admin.shipments')}}</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">

                    <div class="mt-5">
                        <h5 class="mb-3">تفاصيل الطلب :</h5>

                        <div class="table-responsive">
                            <table class="table mb-0 table-bordered">
                                <tbody>
                                <tr>
                                    <th scope="row" style="width: 400px;">{{__('admin.type')}}</th>
                                    <td>{{$shipment->type}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.weight')}}</th>
                                    <td>{{$shipment->weight}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.insurance_type')}}</th>
                                    <td>{{$shipment->insurance_type?->type}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.status')}}</th>
                                    <td>
                                        @if($shipment->status==0)
                                            {{__('admin.pending')}}
                                        @elseif($shipment->status==1)
                                            {{__('admin.packing')}}

                                        @elseif($shipment->status==2)
                                            {{__('admin.packed')}}
                                        @elseif($shipment->status==3)
                                            {{__('admin.delivering')}}
                                        @else
                                            {{__('admin.delivered')}}

                                        @endif
                                    </td>
                                </tr>

                                <tr>
                                    <th scope="row">{{__('admin.description')}}</th>
                                    <td>{{$shipment->description}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.driver')}}</th>
                                    <td> {{$shipment->drivers()->where('shipment_drivers.status',1)->first()?->name}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.sender')}}</th>
                                    <td>{{$shipment->sender->name}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.user_price')}}</th>
                                    <td> {{$shipment->user_price}} </td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.driver_price')}} </th>
                                    <td> {{$shipment->driver_price}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.final_price')}} </th>
                                    <td> {{$shipment->final_price}} </td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.packing_date')}} </th>
                                    <td>{{$shipment->packing_date}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.packing_time')}} </th>
                                    <td> {{$shipment->packing_time}} </td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.from_address')}} </th>
                                    <td>
                                        <a target="_blank" href="https://maps.google.com/maps/search/?q={{$shipment->from_address->latitude}},{{$shipment->from_address->longitude}}&hl=es&z=14&output=embed">
                                            {{__('admin.location')}}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.from_address_detail')}} </th>
                                    <td>{{$shipment->from_address_details?->address_name}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.to_address')}} </th>
                                    <td>
                                        <a target="_blank" href="https://maps.google.com/maps/search/?q={{$shipment->to_address->latitude}},{{$shipment->to_address->longitude}}&hl=es&z=14&output=embed">
                                            {{__('admin.location')}}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.to_address_detail')}} </th>
                                    <td> {{$shipment->to_address_details?->address_name}}</td>
                                </tr>
                                <tr>
                                    <th scope="row">{{__('admin.receiver')}} </th>
                                    <td>{{$shipment->receiver?->name}}</td>
                                </tr>
                                <tr>
                                    <th scope="row"> {{__('admin.truck')}} </th>
                                    <td>  {{$shipment->truck?$shipment->truck->type?->type_ar:'-'}} </td>
                                </tr>
                                <tr>
                                    <th scope="row"> {{__('admin.number_of_trucks')}} </th>
                                    <td>  {{$shipment->number_of_trucks}}</td>
                                </tr>
                                <tr>
                                    <th scope="row"> {{__('admin.shipment_invoice_picture')}} </th>
                                    <td>  <img width="150px" height="150px" src="{{asset('images/'.$shipment->shipment_invoice_picture)}}"> </td>
                                </tr>
                                <tr>
                                    <th scope="row"> {{__('admin.packing_list_picture')}} </th>
                                    <td>  <img width="150px" height="150px" src="{{asset('images/'.$shipment->packing_list_picture)}}"> </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
            <!-- end card -->
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table align-middle table-nowrap table-check">
                            <thead class="table-light">
                            <tr>
                                <th class="align-middle">{{__('admin.truck')}}</th>
                                <th class="align-middle">{{__('admin.driver')}}</th>
                                <th class="align-middle">{{__('admin.status')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                                    <tr>
                                        <td>
                                            <div class="mb-3">
                                                <div class="input-box">
                                                    <label for="truck_id">{{__('admin.trucks')}}</label>
                                                    <select class="form-select form-control" name="truck_id" id="truck_id" onchange="this.options[this.selectedIndex].value && (window.location = '{{route('shipper.shipments.change',$shipment->id)}}'+'?truck_id='+this.options[this.selectedIndex].value);" required>
                                                        <option selected  value="">{{__('admin.choose-truck')}}</option>
                                                        @if(count($trucks)>0)
                                                            @foreach($trucks as $truck)
                                                                <option @if($shipment->truck_id==$truck->id) selected @endif  value="{{$truck->id}}">{{$truck->type->type_ar}}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>

                                        </td>
                                        <td>
                                            <div class="mb-3">
                                                <div class="input-box">
                                                    <label for="driver_id">{{__('admin.drivers')}}</label>
                                                    <select class="form-select form-control" name="driver_id" id="driver_id" onchange="this.options[this.selectedIndex].value && (window.location = '{{route('shipper.shipments.change',$shipment->id)}}'+'?driver_id='+this.options[this.selectedIndex].value);" required>
                                                        <option selected  value="">{{__('admin.choose-truck')}}</option>
                                                        @if(count($drivers)>0)
                                                            @foreach($drivers as $driver)
                                                                <option @if($shipment->selectedDriver()->first() && $shipment->selectedDriver()->first()->id==$driver->id) selected @endif  value="{{$driver->id}}">{{$driver->name}}</option>
                                                            @endforeach
                                                        @endif
                                                    </select>
                                                </div>
                                            </div>

                                        </td>
                                        <td>
                                            <div class="mb-3">
                                                <div class="input-box">
                                                    <label for="driver_id">{{__('admin.status')}}</label>
                                                    <select
                                                onchange="this.options[this.selectedIndex].value && (window.location = '{{route('shipper.shipments.change',$shipment->id)}}'+'?status='+this.options[this.selectedIndex].value);"
                                                    name="status" class="form-select">
                                                <option label="{{__('admin.select-status')}}"></option>
0
                                                <option value="0"
                                                        @if($shipment->status==0) selected @endif >{{__('admin.pending')}} </option>
                                                <option value="1"
                                                        @if($shipment->status==1) selected @endif >{{__('admin.packing_in_progress')}} </option>
                                                <option value="2"
                                                        @if($shipment->status==2) selected @endif >{{__('admin.Packed')}} </option>
                                                <option value="3"
                                                        @if($shipment->status==3) selected @endif >{{__('admin.in_delivery')}} </option>
                                                <option value="4"
                                                        @if($shipment->status==4) selected @endif >{{__('admin.delivered')}} </option>
                                            </select>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->
@endsection

@section('extra-js')
    <script src="{{asset('admin_assets/libs/select2/js/select2.min.js')}}"></script>
    <!-- bootstrap-datepicker js -->
    <script src="{{asset('admin_assets/libs/bootstrap-datepicker/js/bootstrap-datepicker.min.js')}}"></script>

    <!-- Required datatable js -->
    <script src="{{asset('admin_assets/libs/datatables.net/js/jquery.dataTables.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-bs4/js/dataTables.bootstrap4.min.js')}}"></script>

    <!-- Responsive examples -->
    <script src="{{asset('admin_assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
    <script src="{{asset('admin_assets/libs/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

    <!-- init js -->
    <script src="{{asset('admin_assets/js/pages/crypto-orders.init.js')}}"></script>


@endsection
