<?php

use App\Http\Controllers\Admin\AdminLoginController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\SettingsController;
use App\Http\Controllers\Admin\SuggestionsController;
use App\Http\Controllers\Admin\TechnicalSupportController;
use App\Http\Controllers\Admin\CountriesController;
use App\Http\Controllers\Admin\ShipmentCountriesController;
use App\Http\Controllers\Admin\ShipmentCitiesController;
use App\Http\Controllers\Admin\ShipmentGovernoratesController;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\ForbiddenItemsController;
use App\Http\Controllers\Admin\ShipmentsController;
use App\Http\Controllers\Admin\DriversController;
use App\Http\Controllers\Admin\NotificationsController;
use App\Http\Controllers\Admin\TrucksController;
use App\Http\Controllers\Admin\TruckCategoriesController;
use App\Http\Controllers\Admin\TruckTypesController;
use App\Http\Controllers\Admin\TruckModelsController;
use App\Http\Controllers\Admin\TruckHeightsController;
use App\Http\Controllers\Admin\TruckWidthsController;
use App\Http\Controllers\Admin\TruckLengthsController;
use App\Http\Controllers\Admin\TruckLoadCapacitiesController;
use App\Http\Controllers\Admin\TruckNumberOfAxlesController;
use App\Http\Controllers\Admin\AdminsController;
use App\Http\Controllers\Admin\RolesController;
use App\Http\Controllers\Admin\ShippersController;
use App\Http\Controllers\Admin\SlidersController;
use App\Http\Controllers\Admin\HowShipmentController;
use App\Http\Controllers\Admin\ReportsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/



Route::group([ 'middleware'=>'guest:admin','prefix'=>'admin'],function(){
    Route::get('login',[AdminLoginController::class , 'login'])->name('admin.login');
    Route::post('submit-login',[AdminLoginController::class , 'submit_login'])->name('admin.submit.login');
});


Route::group(['middleware'=>'auth:admin','prefix'=>'admin'],function(){
    Route::get('dashboard',[AdminLoginController::class , 'dashboard'])->name('admin.dashboard');
    Route::get('logout',[AdminLoginController::class , 'logout'])->name('admin.logout');
//    Route::get('profile',[ProfileController::class , 'index'])->name('admin.profile');
//    Route::put('profile/update/{admin}',[ProfileController::class , 'update'])->name('update.profile');


    Route::group(['as' => 'admin.'],function(){

        Route::resource('settings' , SettingsController::class);
        Route::resource('suggestions' , SuggestionsController::class);
        Route::resource('technical' , TechnicalSupportController::class);
        Route::resource('country' , CountriesController::class);
        Route::resource('how-shipment' , HowShipmentController::class);
        Route::resource('shipment-country' , ShipmentCountriesController::class);
        Route::resource('shipment-city' , ShipmentCitiesController::class);
        Route::resource('shipment-governorate' , ShipmentGovernoratesController::class);
        Route::get('users/status/{user_id}',[UsersController::class , 'status'])->name('users.status');

        Route::resource('trucks' , TrucksController::class);
        Route::resource('truck-categories' , TruckCategoriesController::class);
        Route::resource('truck-types' , TruckTypesController::class);
        Route::resource('truck-models' , TruckModelsController::class);
        Route::resource('truck-heights' , TruckHeightsController::class);
        Route::resource('truck-widths' , TruckWidthsController::class);
        Route::resource('truck-lengths' , TruckLengthsController::class);
        Route::resource('truck-load-capacities' , TruckLoadCapacitiesController::class);
        Route::resource('truck-number-of-axles' , TruckNumberOfAxlesController::class);
        Route::resource('users' , UsersController::class);
        Route::resource('notifications' , NotificationsController::class);
        Route::resource('forbidden-items' , ForbiddenItemsController::class);
        Route::resource('shipments' , ShipmentsController::class);
        Route::get('drivers/status/{driver_id}',[DriversController::class , 'status'])->name('drivers.status');
        Route::get('drivers/accept/{driver_id}',[DriversController::class , 'accept'])->name('drivers.accept');
        Route::get('drivers/rates/{driver_id}',[DriversController::class , 'rates'])->name('drivers.rates');

        Route::resource('drivers' , DriversController::class);
        Route::resource('admins' , AdminsController::class);
        Route::resource('roles' , RolesController::class);
        Route::resource('shippers' , ShippersController::class);
        Route::resource('sliders', SlidersController::class);
        Route::get('reports',[ReportsController::class,'index'])->name('reports.index');
        Route::get('reports/excel',[ReportsController::class,'downloadExcel'])->name('reports.download.excel');

    });






});

