<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\UserRequest;
use App\Http\Resources\CompleteRegisterResource;
use App\Http\Resources\InterestResource;
use App\Http\Resources\UserResource;
use App\Models\Interest;
use App\Models\InterestUser;
use App\Models\User;
use App\Models\VonHistory;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthUserController extends Controller
{
    public function register(UserRequest $request)
    {
        
    //     dd("fff");  
        
      if(User::where('email',$request->email)->first()){
            return $this->apiResponse(400 ,'The email has already been taken.',null);
      }
        
        $user = User::create([
        'name' => $request->name,
        'email' => $request->email,
        'password' => Hash::make($request->password),
        'mobile' => $request->mobile ?? null,
        ]);

        $token = Auth::login($user);
        $user = new UserResource(auth()->user()) ;
        $user['token'] = $token;
        
        $von_text = $request->name." has now joined VONNN";
        
      VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $user->id , 'von_type' => 'new_account']);


        return $this->apiResponse(200 ,'register is success',$user);
    }

    public function complete_register(Request $request)
    {
        $user = auth()->user();
        $user->interests()->attach($request->interests);
        $user->type = $request->type;
        $user->save();
        
        $token = Auth::login($user);
        $user = new UserResource(auth()->user()) ;
        $user['token'] = $token;

        return $this->apiResponse(200 ,'register is completed', $user);
    }


    public function login()
    {
        $credentials = request(['email', 'password']);

        if (! $token = auth('api')->attempt($credentials)) {
            return $this->apiResponse(401 ,'email or password is invalid', null );
        }
           $user = new UserResource(auth()->user()) ;
           $user['token'] = $token;
           $user['age'] = Carbon::parse($user['birthdate'])->age;

        return $this->apiResponse(200 ,'login is success',$user );
    }


    public function logout()
    {
        auth('api')->logout();
        return response()->json(['message' => 'Successfully logged out']);
    }


    public function update_token(Request $request){

       $user = auth()->user();

        if(!$user){
          return  $this->apiResponse(401 ,'not authorized', null );
        }
 
         
         $user->google_id = $request->token;
         $user->save();
 


        return $this->apiResponse(200 ,'token updated', null );

 }
 

    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 60
        ]);
    }


    public function forgetPassword(Request $request)
    {
        $user = User::where('email',$request->email)->first();
        if($user){

        // $code = rand(1111,9999);
        $code = 1111;
        $user->forget_code = $code;
        $user->save();

        // send code to user at email

        return $this->apiResponse(200 , 'code is sent' , $code );
        }
        return $this->apiResponse(404 , 'user not found' , null );
    }

    public function check_forget_Code(Request $request)
    {
        if($request->code){
           $user = User::where('forget_code',$request->code)->first();
        if($user){
        return $this->apiResponse(200 , 'code is valid' , null);
        }
        return $this->apiResponse(404 , 'code is invalid' , null);
        }

    }

    public function resetPassword(Request $request)
    {

        $user = User::where('forget_code',$request->code)->first();
        $user->update([
            'password' => Hash::make($request->new_password),
        ]);
        return $this->apiResponse(200 , 'password is updated' , null);
    }


    public function get_interests()
    {
        $interests = Interest::get();
        
        foreach($interests as $interest){
             $interest->image = $interest->image;
        }
        
        return $this->apiResponse(200 , null , InterestResource::collection($interests));
    }



}
