<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Resources\CareerResource;
use App\Http\Resources\CareerMemberResource;
use App\Models\Career;
use App\Models\CareerMember;
use App\Models\VonHistory;


class CareerController extends Controller
{
    public function careers(Request $request)
    {
        $careers = Career::where('user_id',$request->user_id)->get();
    
        foreach($careers as $career){
         if($career){
         $career->members = CareerMemberResource::collection(CareerMember::where('career_id',$career->id)->get());
         }else {
             $career->members = null;
         }
         
        }
         
         
         
        return $this->apiResponse(200 , null , CareerResource::collection($careers));
    }
    
    
    public function save_career(Request $request)
    {
        
        $user = auth()->user();    
        
        $file_name="";
        
         if($request->hasFile('image')){

        $image = $request->file('image');
        $file_name = Time().'-'.$image->getClientOriginalName();
        $file_path = public_path().'/images';
        $image->move($file_path,$file_name);
        }
        
        
        $career = Career::create([
            'type' => $request->type,
            'privacy'=> $request->privacy,
            'event_name'=> $request->event_name,
            'long'=>  $request->lng,
            'lat' => $request->lat,
            'end_lat'=>  $request->end_lat,
            'end_lng' => $request->end_lng,
            'date'=>  $request->date,
            'description'=> $request->description,
            'image' => $file_name,
            'user_id'=>$user->id
            ]);
            
          
            $von_text = $user->name."  has created their career"; 
            
        VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $career->id , 'von_type' => 'career_created' , 'image' => $file_name]);
            
          $crew_ids = explode(",",$request->crew_ids) ;
                    
        
          $crews= CareerMember::where('career_id',$career->id);
           
           if($crews){
               
              $crews->delete();
           }
        
       
        
            if($crew_ids){
                
              for($i=0; $i<count($crew_ids); $i++){   
            
                    if($crew_ids[$i]){
                   CareerMember::create([
                        'career_id' => $career->id,
                       'member_id'=> $crew_ids[$i],
                           ]);
                    }
            
                }
            }
       
        
            
        return $this->apiResponse(200 , null , new CareerResource($career));
    }
    
    
    public function update_career(Request $request)
    {
        
        $user = auth()->user();  
        
        $file_name=null;
         if($request->hasFile('image')){

        $image = $request->file('image');
        $file_name = Time().'-'.$image->getClientOriginalName();
        $file_path = public_path().'/images';
        $image->move($file_path,$file_name);
        }
        
        $career = Career::where('id',$request->career_id)->first();
        $career->type = $request->type;
        $career->privacy = $request->privacy;
        $career->event_name = $request->event_name;
        $career->long = $request->lng;
        $career->lat = $request->lat;
        $career->date = $request->date;
        $career->description = $request->description;
        
      
       $von_text = $user->name."  has updated their career";         
        
      VonHistory::create(['user_id' => $career->user_id , 'text' => $von_text, 'von_id' => $career->id , 'von_type' => 'career_created' ]);

        
        
        if($file_name){
             $career->image = $file_name;
        }
        
        
        
        $career->save();
        
        
        
           $crew_ids = explode(",",$request->crew_ids) ;
                    
        
          $crews= CareerMember::where('career_id',$career->id);
           
           if($crews){
               
              $crews->delete();
           }
        
       
        
            if($crew_ids){
                
              for($i=0; $i<count($crew_ids); $i++){   
            
                    if($crew_ids[$i]){
                   CareerMember::create([
                        'career_id' => $career->id,
                       'member_id'=> $crew_ids[$i],
                           ]);
                    }
            
                }
            }
            
        
       
        return $this->apiResponse(200 , null , new CareerResource($career));
    }
    
    
    public function delete_career(Request $request)
    {
        $career = Career::where('id',$request->career_id)->first();
        $career->delete();
        return $this->apiResponse(200 , 'career is deleted' , null);
    }
    
    
    
    
    
}
