<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Champion;
use App\Models\Category;
use App\Models\User;
use App\Models\ChampionCrew;
use App\Models\Job;
use App\Models\JobTitle;
use App\Models\Course;
use App\Models\CourseUser;
use App\Models\Event;
use App\Models\EventCrew;
use App\Models\VonHistory;
use App\Models\Notification;

class ChampionController extends Controller
{
    public function champions(Request $request)
     {
        $champions = Champion::select('id','name','image','category_id','user_id','type')->where('user_id',$request->user_id)->get();
        
        
        foreach($champions as $champion){
            
            
            $champion->image = asset('images/').'/'.$champion->image;
            $champion->category = Category::select('id','name')->where('id',$champion->category_id)->first();
            $champion->crews = ChampionCrew::select('id','crew_id','title_id')->where('champion_id',$champion->id)->get();
            
                
                if($champion->type==1){
                    $champion->type="Vechicle";
                }else {
                    $champion->type="Motorcycle";
                }
                
                
            foreach($champion->crews as $crew){
                 
                $crew->name = User::where('id',$crew->crew_id)->first()->name;
                $crew->title = JobTitle::where('id',$crew->title_id)->first()->name;
               // dd($crew->title);
            }
            
         
            //$champion->crew = JobTitle::where();
            
        }
        
        return $this->apiResponse(200 , null , $champions);
     }
     
     
     
   public function save_user_event(Request $request)
   {
         
         $user = auth()->user();
     
          $crews_ids = explode(",",$request->crew_ids) ;
          $sponsor_ids = explode(",",$request->sponsor_ids) ;
          $partners_ids = explode(",",$request->partners_ids) ;
          
     $image_name="";
             
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
         
                 
        $event = Event::create([
            'name' => $request->name,
            'details'=> $request->details,
            'champion_id'=> $request->champion_id,
            'race_capacity' => $request->racer_capacity,
            'audience_capacity'=> $request->audience_capacity,
            'champion_id'=> $request->champion_id,
            'lat'=> $request->lat,
            'long'=> $request->lng,
            'length'=> $request->length,
            'turns_no'=> $request->turns_number,
            'turns_number'=> $request->turns_number,
            'date'=> $request->date,
            'venue_user_id'=>$request->venue_user_id,
            'best_record_user_id'=> $request->best_record_user_id,
            'best_record_hours'=> $request->best_record_hours,
            'best_record_minutes'=> $request->best_record_minutes,
            'best_record_seconds'=> $request->best_record_seconds,
            'type'=> $request->type,
            'user_id'=>$user->id,
            'image'=>$image_name
            
            ]);
            
            
            
            $von_text = $user->name." has created their event ".$request->name;

             VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $event->id , 'von_type' => 'champion_event_created' ,'image' => $image_name]);


               
         $notification_title = "Event Best Record";
         
        $notification_body = $user->name.' invited you to as a event best lab record';
        
                
         $tokens = User::where('id',$request->best_record_user_id)->pluck('google_id');
         
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $request->best_record_user_id,
                   'notification_type'=>31
                   ]);
                   
         
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		 $this->send_multi_notification($tokens,$message_complete);
		 
        if($sponsor_ids){   
            
            
            $notification_title = "Event Sponser";
         
        $notification_body = $user->name.' invited you to as a sponsor to '.$request->name.' ) ('.$request->date.')';
        
            
        for($i=0; $i<count($sponsor_ids); $i++){   
            
           EventCrew::create([
            'event_id' => $event->id,
            'crew_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
            
          Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $sponsor_ids[$i],
                   'notification_type'=>32
                   ]); 
        }
        
         $tokens = User::whereIn('id',$sponsor_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>"Event sponsor",'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
		 
        
     }
        
        if($partners_ids){
            
            $notification_title = "Event Partners";
         
        $notification_body = $user->name.' invited you to as a partner to ('.$request->name.') ('.$request->date.')';
        
            
         for($i=0; $i<count($partners_ids); $i++){   
            
           EventCrew::create([
            'event_id' => $event->id,
            'crew_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
            
              Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $partners_ids[$i],
                   'notification_type'=>33
                   ]); 
                   
        }
        
        
            $tokens = User::whereIn('id',$sponsor_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>"Event partner",'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
        
        
        }
        
        
        
        if($crews_ids){
            
        $notification_title = "Event Crew";
        $notification_body = $user->name.' invited you to as a crew to ('.$request->name.') ('.$request->date.')';
        
        for($i=0; $i<count($crews_ids); $i++){   
            
           EventCrew::create([
            'event_id' => $event->id,
            'crew_id'=> $crews_ids[$i],
            'type'=>3,
            'user_rank' => $request->user_rank,
        ]);
        
        
        Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $event->id,
                   'user_id'=> $crews_ids[$i],
                   'notification_type'=>34
                   ]);
                   
        }
        
        
             $tokens = User::whereIn('id',$crews_ids)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
        
        
        
        
        }
            
        return $this->apiResponse(200 , null ,$event);
     }
     
     
         public function save_champion(Request $request)
     {
         
         $user = auth()->user();
         
         $crew_ids = explode(",",$request->crew_ids) ;
         $crew_title_ids = explode(",",$request->crew_title_ids) ;
         
         $image_name="";
         
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
                 
        $champion = Champion::create([
            'name' => $request->name,
            'type'=> $request->type,
            'image' => $image_name,
            'category_id'=> $request->category_id,
            'user_id'=>$user->id
            ]);
            
            
            $von_text = $user->name." has created their champion ".$request->name;

          VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $champion->id , 'von_type' => 'champion_updated' ,'image' => $image_name]);
            
        for($i=0; $i<count($crew_ids); $i++){   
            
            if($crew_ids[$i]>0){
           ChampionCrew::create([
            'champion_id' => $champion->id,
            'crew_id'=> $crew_ids[$i],
            'title_id'=> $crew_title_ids[$i],
            ]);
            }
        }
            
        return $this->apiResponse(200 , null ,$champion);
     }
     
     
    
    public function update_champion(Request $request)
     {
         
         $user = auth()->user();
         
         
         $champion = Champion::where('id',$request->champion_id)->first();
 
         $crew_ids = explode(",",$request->crew_ids) ;
         $crew_title_ids = explode(",",$request->crew_title_ids) ;

       
       $image_name="";
         
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        $champion->image  = $image_name;
        }
                 
         
                 
      $von_text = $user->name." has updated their champion ".$request->name;
  
    VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $champion->id , 'von_type' => 'champion_updated' ,'image' => $image_name]);
   
      
    
            $champion->name  = $request->name;
            $champion->type  = $request->type;
            $champion->category_id  = $request->category_id;
             
            

    
        ChampionCrew::where('champion_id',$champion->id)->delete();

         
            
        for($i=0; $i<count($crew_ids); $i++){   
            
            if($crew_ids[$i]>0){
           ChampionCrew::create([
            'champion_id' => $champion->id,
            'crew_id'=> $crew_ids[$i],
            'title_id'=> $crew_title_ids[$i],
            ]);
            }
        }
        
        $champion->save();
            
        return $this->apiResponse(200 , null ,$champion);
     }
     
     
     public function user_events(Request $request)
     {
         
        $events = Event::select('id','name','champion_id','audience_capacity','race_capacity','date','lat','long as lng','details','length','turns_number','best_record_user_id','best_record_hours','best_record_minutes','best_record_seconds','image','type','venue_user_id')->where('user_id',$request->user_id)->get();
        
            foreach($events as $event){
                
            $event->type == 1 ? $event['type'] = 'Street' : $event['type'] = 'Race Venue';
            
            $event['venue_user'] = User::select('id','name')->where('id',$event->venue_user_id)->first();
            unset($event->venue_user_id);
            
            $champion = Champion::select('id','name','image','category_id','user_id','type')->where('id',$event->champion_id)->first();
            
            
            $sponsers = array();
            $partners = array();
            $racers = array();
            $venue_user = array();
            
            
            $event->best_record = User::select('id','name')->where('id',$event->best_record_user_id)->first();
            
            $champion->image =  $champion->image != null ? asset('images/').'/'.$event->image : null;
            $champion->category = Category::select('id','name')->where('id',$champion->category_id)->first();
            
            $event_users = EventCrew::where('event_id',$event->id)->get();
            
          
            
            foreach($event_users as $event_user){
                
                $user = User::select('id','name')->where('id',$event_user->crew_id)->first();
                
                  
                  
                 if($user){
                     
                       if($event_user->type==1){
                     array_push($sponsers,$user);
                       }else if($event_user->type==2){
                          array_push($partners,$user);
                          }else {
                         array_push($racers,$user);
                          }
            
                    }
            }
            
            $event->sponsers = $sponsers;
            $event->partners = $partners;
            $event->racers = $racers;

         if($champion->type==1){
            $champion->type="Car Racer";
        }else {
            $champion->type="Moto Racer";
        }
            $event->champion = $champion;
        }
 
        return $this->apiResponse(200 , null , $events);
     }
     
     
     
  public function edit_user_event(Request $request)
   {
         
         $user = auth()->user();
     
          $crews_ids = explode(",",$request->crew_ids) ;
          $sponsor_ids = explode(",",$request->sponsor_ids) ;
          $partners_ids = explode(",",$request->partners_ids) ;
          
         $image_name="";
             
      if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        }
         
                 
        $event = Event::where('id',$request->event_id)->first();
            
          $event->name = $request->name;
          $event->details = $request->details;
          $event->champion_id = $request->champion_id;
          $event->race_capacity = $request->racer_capacity;
          $event->audience_capacity = $request->audience_capacity;
          $event->champion_id = $request->champion_id;
          $event->lat = $request->lat;
          $event->long = $request->lng;
          $event->length = $request->length;
          $event->turns_number = $request->turns_number;
          $event->turns_no = $request->turns_number;
          $event->date = $request->date;
          $event->venue_user_id = $request->venue_user_id;
          $event->best_record_user_id = $request->best_record_user_id;
          $event->best_record_minutes = $request->best_record_minutes;
          $event->best_record_hours = $request->best_record_hours;
          $event->best_record_seconds = $request->best_record_seconds;
          $event->type = $request->type;
          $event->image = $image_name;
          
          
          
    $von_text = $user->name." has created their event ".$request->name;
          
    VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $event->id , 'von_type' => 'champion_event_updated' ,'image' => $image_name]);

          
         
         $event->save();
 
         EventCrew::where('event_id',$event->id)->delete();
 
            
        for($i=0; $i<count($sponsor_ids); $i++){   
            
           EventCrew::create([
            'event_id' => $event->id,
            'crew_id'=> $sponsor_ids[$i],
            'type'=>1
            ]);
            
        }
        
         for($i=0; $i<count($partners_ids); $i++){   
            
           EventCrew::create([
            'event_id' => $event->id,
            'crew_id'=> $partners_ids[$i],
            'type'=>2
            ]);
            
        }
        
        if($crews_ids){
        
         for($i=0; $i<count($crews_ids); $i++){   
            
           EventCrew::create([
            'event_id' => $event->id,
            'crew_id'=> $crews_ids[$i],
            'type'=>3
            ]);
            
        }
        }
            
        return $this->apiResponse(200 , null ,$event);
     }
     
     
    public function club_members()
     {
        $clubs = ClubMember::get();
        return $this->apiResponse(200 , null ,ClubMemberResource::collection($clubs));
     }
     
     
    public function save_club(Request $request)
     {
        $club = Club::create([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function save_club_member(Request $request)
    {
        $member = ClubMember::create([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    public function update_club(Request $request)
     {
         $club = Club::where('id',$request->club_id)->first();
         
         $club->update([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function update_club_member(Request $request)
    {
        $member = ClubMember::where('id',$request->club_member_id)->first();

        $member->update([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    
    public function delete_champion(Request $request)
     {
         $champion = Champion::where('id',$request->champion_id)->first();
         
         $champion->delete();
         
         
         Event::where('champion_id',$request->champion_id)->delete();

         return $this->apiResponse(200 , "champion is deleted" , null);
     }
     
     
    public function delete_club_member(Request $request)
    {
        $club = ClubMember::where('id',$request->club_member_id)->first();

        $club->delete();
        
        return $this->apiResponse(200 , "member is deleted" , null);
    }
    
            function send_multi_notification($tokens,$message_complete ){


    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
}
