<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Club;
use App\Models\ClubMember;
use App\Models\VonHistory;
use App\Models\Notification;
use App\Models\User;

use App\Http\Resources\ClubMemberResource;
use App\Http\Resources\ClubResource;


class ClubController extends Controller
{
    public function clubs(Request $request)
     {
        $club = Club::where('user_id',$request->user_id)->first();
        
        
         if($club){
         $club->members = ClubMemberResource::collection(ClubMember::where('club_id',$club->id)->get());
         }else {
             return $this->apiResponse(200 , null , null);
         }
         
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function club_members()
     {
        $clubs = ClubMember::get();
        return $this->apiResponse(200 , null ,ClubMemberResource::collection($clubs));
     }
     
     
    public function save_club(Request $request)
     {
        $user = auth()->user();
        $club = Club::where('user_id',$user->id);
        $old_club = false;
     if($club){
        $old_club = true;
        $club->delete();
        }
        $club = Club::create([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            'user_id' => $user->id
        ]);
        
      
        if($request->owner_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club owner";
                
            
         $notification_type = $request->owner_id;
         
          $tokens = User::where('id',$request->owner_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
           Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->president_id,
                   'notification_type'=>10
                   ]); 
        }
        
        
        if($request->president_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club president";
                
            
         $notification_type = $request->president_id;
         
          $tokens = User::where('id',$request->owner_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
        Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->president_id,
                   'notification_type'=>11
                   ]); 
        }
        
        
        if($request->vice_president_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club vice president";
                
            
         $notification_type = $request->vice_president_id;
         
          $tokens = User::where('id',$request->vice_president_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
        Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->vice_president_id,
                   'notification_type'=>12
                   ]); 
        }
        
        
        if($request->manager_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club manager";
            
         $notification_type = $request->manager_id;
         
          $tokens = User::where('id',$request->manager_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
        Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->manager_id,
                   'notification_type'=>13
                   ]); 
        }
        
        if($request->communication_director_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club director";
           
         $notification_type = $request->communication_director_id;
         
          $tokens = User::where('id',$request->communication_director_id)->pluck('google_id');
          
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
		    
		    
            Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->communication_director_id,
                   'notification_type'=>14
                   ]); 
        }
        
        if($request->assistant_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club assistant";
                
            
         $notification_type = $request->assistant_id;
         
          $tokens = User::where('id',$request->assistant_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
             Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->assistant_id,
                   'notification_type'=>15
                   ]);  
        }
        
        if($request->facilitator_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club facilitator";
                
            
         $notification_type = $request->facilitator_id;
         
          $tokens = User::where('id',$request->facilitator_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->facilitator_id,
                   'notification_type'=>16
                   ]);  
        }
        
        
           if($request->marcher_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club marcher";
                
            
         $notification_type = $request->marcher_id;
         
          $tokens = User::where('id',$request->marcher_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->marcher_id,
                   'notification_type'=>17
                   ]);  
        }
        
        
        if($request->instructor_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club instructor";
                
            
         $notification_type = $request->instructor_id;
         
          $tokens = User::where('id',$request->instructor_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->instructor_id,
                   'notification_type'=>18
                   ]);  
        }
        
        
          if($request->team_leader_id){
            
            $notification_title = "Club Request";
           $notification_body = $user->name." accepted your request to be  the club team leader";
                
            
         $notification_type = $request->team_leader_id;
         
          $tokens = User::where('id',$request->team_leader_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		    $this->send_multi_notification($tokens,$message_complete);
        
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->team_leader_id,
                   'notification_type'=>19
                   ]);  
        }
        
        
        
        
        
        
        
            
        if(!$old_club){
            
            $von_text = $user->name." has updated their club details";    
            
            VonHistory::create(['user_id' => $user->id , 'text' =>$von_text, 'von_id' => $club->id , 'von_type' => 'Club Created']);
        }else {
            
           $von_text = $user->name." has added their club details";    
            VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $club->id , 'von_type' => 'club_updated']);
        
        }
        
        if($request->added_members){
            
                   $notification_title = "Club Request";
           $notification_body = $user->name." has invited you to be one of the club members?";
            
            $all_crews= array();
            
           $crews= ClubMember::where('club_id',$club->id);
           
        if($crews){
           $crews->delete();
        }
        
        
        for($i=0; $i<count($request->added_members); $i++){  
            
        $member = ClubMember::create([
            'user_id' => $request->added_members[$i] ,
            'club_id' => $club->id
        ]);    
        
        array_push($all_crews,$request->added_members[$i]);
        
          Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => $club->id,
                   'user_id'=> $request->added_members[$i],
                   'notification_type'=>20
                   ]); 
        }
         $tokens = User::whereIn('id',$all_crews)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
        }
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function save_club_member(Request $request)
    {
        $member = ClubMember::create([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    public function update_club(Request $request)
     {
         
         $user = auth()->user();
         
         
         $club = Club::where('id',$request->club_id)->first();
         
         $club->update([
            'owner_id' => $request->owner_id,
            'president_id'=> $request->president_id,
            'vice_president_id'=> $request->vice_president_id,
            'manager_id'=> $request->manager_id,
            'communication_director_id'=> $request->communication_director_id,
            'assistant_id'=> $request->assistant_id,
            'facilitator_id'=> $request->facilitator_id,
            'marcher_id'=> $request->marcher_id,
            'instructor_id'=> $request->instructor_id,
            'team_leader_id' => $request->team_leader_id,
            ]);
            
            
            
            
            $von_text = $user->name." has updated their club details"; 
            
             VonHistory::create(['user_id' => $user->user_id , 'text' => $von_text , 'von_id' => $club->id , 'von_type' => 'club_updated']);
             
        return $this->apiResponse(200 , null , new ClubResource($club));
     }
     
     
    public function update_club_member(Request $request)
    {
        $member = ClubMember::where('id',$request->club_member_id)->first();

        $member->update([
            'user_id' => $request->user_id ,
            'club_id' => $request->club_id
            ]);
        return $this->apiResponse(200 , null , new ClubMemberResource($member));
    }
    
    
    public function delete_club(Request $request)
     {
         $club = Club::where('id',$request->club_id)->first();
         
         $club->delete();

         return $this->apiResponse(200 , "club is deleted" , null);
     }
     
     
    public function delete_club_member(Request $request)
    {
        $club = ClubMember::where('id',$request->club_member_id)->first();

        $club->delete();
        
        return $this->apiResponse(200 , "member is deleted" , null);
    }
    
      function send_multi_notification($tokens,$message_complete ){


    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
}
