<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\AlbumMediaResource;
use App\Http\Resources\AlbumResource;
use App\Http\Resources\CameraResource;
use App\Http\Resources\CrewResource;
use App\Http\Resources\ImageResource;
use App\Http\Resources\LensResource;
use App\Http\Resources\UserResource;
use App\Models\Album;
use App\Models\AlbumMedia;
use App\Models\VonHistory;
use App\Models\Camera;
use App\Models\Crew;
use App\Models\JobTitle;
use App\Models\Lens;
use App\Models\Event;
use App\Models\User;
use Illuminate\Http\Request;

class MediaController extends Controller
{
    public function get_media_data(Request $request)
    {
        $user = User::findOrFail($request->user_id);
        $crews   = $user->crew;
        $lens    = $user->lenses;
        $cameras = $user->cameras;
        
        foreach($crews as $crew){
            $crew->title = JobTitle::select('name')->where('id',$crew->pivot->title_id)->first(); 
            
            if($crew->title )$crew->title = $crew->title->name;
        }

        return $this->apiResponse(200 , null , [
          'cameras' =>  CameraResource::collection($cameras),
          'crews' => CrewResource::collection($crews),
          'lenses' =>  LensResource::collection($lens),
        ]);
    }
    
    
    public function remove_album(Request $request)
    {
         $album = Album::where('id',$request->album_id)->first();
         $album->delete();
         return $this->apiResponse(200 , 'album is deleted' , null);
    }
    
    public function remove_album_media(Request $request)
    {
         $album = AlbumMedia::where('id',$request->media_id)->first(); 
         $album->delete();
         return $this->apiResponse(200 , 'media is deleted' , null);
    }


    public function get_media_by_type(Request $request)
    {
           $media = AlbumMedia::where('type',$request->type)->get();
           return $this->apiResponse(200 , null , AlbumMediaResource::collection($media));

    }

    public function get_albums(Request $request)
    {
          $user = User::findOrFail($request->user_id);
          $albums =  Album::with('images')->where('user_id',$user->id)->get();

          foreach ( $albums as $album) {
            if(count($album->images) > 0){
             $image =  $album->images[0]->media;
             $album['image'] =  $image;
            }
            $albums = AlbumResource::collection( $albums);
          }
          
          
          
        return $this->apiResponse(200 , null ,$albums );
    }

    public function get_album_images(Request $request)
    {
        $album = Album::findOrFail($request->album_id);
        $images = $album->images;
        
        foreach($images as $image){
            
            
            $image->media = asset('/').'/images/'.$image->media;
            $image->image =  $image->media ;
            $image->camera = Camera::select('id','name')->where('id',$image->camera_id)->first();
            $image->lens = Lens::select('id','name')->where('id',$image->lens_id)->first();
            
            $crew   = Crew::select('id','crew_id','title_id')->where('crew_id',$image->crew_id)->first();
            
            $image->racer  = User::select('id','name')->where('id',$image->racer_id)->first();
            $image->event  = Event::select('id','name')->where('id',$image->event_id)->first();
        
 
            if($crew){
                
            $crew->title = JobTitle::select('name')->where('id',$crew->title_id)->first(); 
            
            
            if($crew->title ){
                $crew->title = $crew->title->name;
            }
            
            $crew->name = User::where('id',$crew->crew_id)->first()->name;
            
            }
            
            $image->crew = $crew;
         
        }
        
        return $this->apiResponse(200 , null , $images);
    }

    public function get_cameras()
    {
        $cameras = Camera::get();
        return $this->apiResponse(200 , null ,  CameraResource::collection($cameras));
    }

    public function get_lenses()
    {
        $lenses = Lens::get();
        return $this->apiResponse(200 , null ,  LensResource::collection($lenses));
    }

    public function add_new_camera(Request $request)
    {
             $user = auth()->user();
             
          if($request->camera_id == -1){
             $camera = Camera::create(['name'=>$request->other , 'status' => 0]);
             $user->cameras()->attach($camera->id);
             return $this->apiResponse(200 , null ,$user->cameras);
             
         } else {
             $user->cameras()->attach($request->camera_id);
             
              $von_text = $user->name." has added their camera";
              
       VonHistory::create(['user_id' => $user->id , 'text' => $von_text, 'von_id' => $request->camera_id , 'von_type' => 'create_camera' ]);

             return $this->apiResponse(200 , null , $user->cameras);
         }
    }

    public function remove_camera(Request $request)
    {
         $user = auth()->user();
         $user->cameras()->detach($request->camera_id);
         return $this->apiResponse(200 , null , null);
    }

    public function add_new_album(Request $request)
    {
        
         $user = auth()->user();
         
         
     if($request->hasFile('image')){

        $image = $request->file('image');
        $file_name = Time().'-'.$image->getClientOriginalName();
        $file_path = public_path().'/images';
        $image->move($file_path,$file_name);
        }
        $user = auth()->user();
        $album = Album::create(['name' => $request->name , 'user_id' => $user->id]);

       $album_media =  AlbumMedia::create([
            'album_id' => $album->id,
            'type' => 'image',
            'media' => $file_name,
        ]);
        
        $von_text = $user->name." has created an album";
        
         VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $album_media->id , 'von_type' => 'create_album' ]);
         
         
         
        return $this->apiResponse(200 , null ,null);
    }

    public function add_album_media(Request $request)
    {
        
         $user = auth()->user();
        
        foreach($request->media as $item){

            $file_name = rand(1000000000, 9999999999).'-'.$item->getClientOriginalName();
            $file_path = public_path().'/images';
            $item->move($file_path,$file_name);

            $media = AlbumMedia::create([
                'album_id' => $request->album_id,
                'type' => $request->type,
                'media' => $file_name,
            ]);
            
            
              VonHistory::create(['user_id' => $user->id , 'text' => "New Album Media has been created" , 'von_id' => $media->id , 'von_type' => 'create_album_media' ]);
            
            $media->album_id = intval($media->album_id);
            $media->media = asset('/').'/images/'.$media->media;
        }
        return $this->apiResponse(200 , null , $media);
    }
    
    
    
   public function get_my_crews()
    {
         
        $user = User::findOrFail(auth()->user()->id);
        $crews   = $user->crew;
        foreach($crews as $crew){
            
            $crew->title = JobTitle::select('name')->where('id',$crew->pivot->title_id)->first(); 
            if($crew->title )$crew->title = $crew->title->name;
        }
        
        return $this->apiResponse(200 , null ,  CrewResource::collection($crews));
    }
    
     public function get_my_lenses()
    {
        
         $user = User::findOrFail(auth()->user()->id);
 
        $lens = $user->lenses;
        
        return $this->apiResponse(200 , null , LensResource::collection($lens));
    }
    
    
     public function get_my_cameras()
    {
         $user = User::findOrFail(auth()->user()->id);
        $cameras = $user->cameras;
        return $this->apiResponse(200 , null , CameraResource::collection($cameras));
    }
    
    
    public function get_my_media_data(){
        
           $user = User::findOrFail(auth()->user()->id);
        $crews   = $user->crew;
        $lens    = $user->lenses;
        $cameras = $user->cameras;
        
        foreach($crews as $crew){
            $crew->title = JobTitle::select('name')->where('id',$crew->pivot->title_id)->first(); 
            
            if($crew->title )$crew->title = $crew->title->name;
        }

        return $this->apiResponse(200 , null , [
          'cameras' =>  CameraResource::collection($cameras),
          'crews' => CrewResource::collection($crews),
          'lenses' =>  LensResource::collection($lens),
        ]);
        
        
    }
    
    
   public function update_album_media(Request $request){
      
      $user = auth()->user();
      
      $album_media =  AlbumMedia::where('id',$request->media_id)->first();
      $album_media->crew_id = $request->crew_id;
      $album_media->camera_id = $request->camera_id;
      $album_media->lens_id = $request->lens_id;
      $album_media->comment = $request->comment;
      $album_media->racer_id = $request->racer_id;
      $album_media->event_id = $request->event_id;
      
      
     
      $album_media->save();
      
      
      
      
            $user_id = $request->crew_id;
            $trip_user = User::select('google_id')->where('id',$user_id)->first();
		     $message_complete = array('title'=>"taged in album",'body'=>$user->name." taged you in his album");
		     
		      if($trip_user){
		     
		    $this->send_notification($trip_user->google_id,$message_complete);
		      }
		    
		    
		    
		    
            $user_id = $request->racer_id;
            $trip_user = User::select('google_id')->where('id',$user_id)->first();
		     $message_complete = array('title'=>"taged in album",'body'=>$user->name." add you as racer in his album");
		     
		     if($trip_user){
		    $this->send_notification($trip_user->google_id,$message_complete);
		     }
		    
      
        
        return $this->apiResponse(200 , null , null);
    }
    
    

    public function add_lens(Request $request)
    {
           $user = auth()->user();
           
        if($request->lens_id == -1){
           $otherLens = Lens::create(['name'=>$request->other , 'status' => 0]);
           $lens =  $user->lenses()->attach($otherLens->id);
          // return $this->apiResponse(200 , null , null);

        } else {
           $lens =  $user->lenses()->attach($request->lens_id);
       
        }
        
        
        $von_text = $user->name." has added their lens";
        
     VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $request->camera_id , 'von_type' => 'create_lens' ]);

     return $this->apiResponse(200 , null , null);
    }

    public function remove_lens(Request $request)
    {
        $user = auth()->user();
       $lens =  $user->lenses()->detach($request->lens_id);
        return $this->apiResponse(200 , null ,null);
    }

    public function job_titles(Request $request)
    {
        $titles =  JobTitle::where('type',$request->type)->get();
        return $this->apiResponse(200 , null , $titles);
    }



    function send_notification($token,$message_complete ){
      
      
    $tokens = array();
     
   
    
    array_push($tokens,$token);
    
 
    
    
    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }



}

