<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Moto;
use App\Models\MotoAirFilter;
use App\Models\MotoBlowOfValve;
use App\Models\MotoBoostController;
use App\Models\MotoBrakeLine;
use App\Models\MotoBrakeMasterCylinder;
use App\Models\MotoBrakePad;
use App\Models\MotoBrakeRotor;
use App\Models\MotoCaliper;
use App\Models\MotoCamShaft;
use App\Models\MotoClutch;
use App\Models\MotoConnectingRod;
use App\Models\MotoControl;
use App\Models\MotoCoolingSystem;
use App\Models\MotoCrankShaft;
use App\Models\MotoCrashBar;
use App\Models\MotoEcu;
use App\Models\MotoEngineBrand;
use App\Models\MotoEngineGuard;
use App\Models\MotoEngineModel;
use App\Models\MotoEngineYear;
use App\Models\MotoFinalDrive;
use App\Models\MotoFork;
use App\Models\MotoFuelinjector;
use App\Models\MotoFuelManagement;
use App\Models\MotoHeader;
use App\Models\MotoHyperCharge;
use App\Models\MotoIgnition;
use App\Models\MotoLoweringLink;
use App\Models\MotoManifold;
use App\Models\MotoNaSuperChrageTurbo;
use App\Models\MotoNos;
use App\Models\MotoPipe;
use App\Models\MotoPiston;
use App\Models\MotoPrimaryDrive;
use App\Models\MotoRimsBrand;
use App\Models\MotoRimsSize;
use App\Models\MotoSeat;
use App\Models\MotoShock;
use App\Models\MotoSilpone;
use App\Models\MotoSprocket;
use App\Models\MotoTiresBrand;
use App\Models\MotoTurboKit;
use App\Models\MotoValve;
use App\Models\MotoWestgate;
use App\Models\MotoStock;
use Illuminate\Http\Request;
use App\Models\MotoRetainer;
use App\Models\MotoTopSpeed;
use App\Models\MotoCategory;
use App\Models\MotoDisplacement;
use App\Models\MotoEngineDetails;
use App\Models\MotoPower;
use App\Models\MotoPowerRpm;
use App\Models\MotoTorque;
use App\Models\MotoTorqueRpm;
use App\Models\MotoZeroOne;
use App\Models\MotoCompression;
use App\Models\MotoStroke;
use App\Models\MotoValvesPerCylinder;
use App\Models\MotoGearBox;
use App\Models\MotoTransmissionType;
use App\Models\MotoWeight;
use App\Models\VonHistory;

    


class MotoController extends Controller
{
    
    public function get_moto_air_filter()
    {
       $data = MotoAirFilter::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_blow_of_valve()
    {
       $data = MotoBlowOfValve::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_boost_controller()
    {
       $data = MotoBoostController::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_retainers()
    {
       $data = MotoRetainer::get();
       return $this->apiResponse(200 , null , $data);
    }

    public function get_moto_brake_line()
    {
       $data = MotoBrakeLine::get();
       return $this->apiResponse(200 , null , $data);
    }

    public function get_moto_brake_master_cylinder()
    {
       $data = MotoBrakeMasterCylinder::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_brake_pad()
    {
       $data = MotoBrakePad::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_brake_rotor()
    {
       $data = MotoBrakeRotor::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_caliper()
    {
       $data = MotoCaliper::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_cam_shaft()
    {
       $data = MotoCamShaft::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_clutch()
    {
       $data = MotoClutch::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_connecting_rod()
    {
       $data = MotoConnectingRod::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_control()
    {
       $data = MotoControl::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_cooling_system()
    {
       $data = MotoCoolingSystem::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_crank_shaft()
    {
       $data = MotoCrankShaft::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_crash_bar()
    {
       $data = MotoCrashBar::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_ecu()
    {
       $data = MotoEcu::get();
       return $this->apiResponse(200 , null , $data);
    }


 


    public function get_moto_engine_guard()
    {
       $data = MotoEngineGuard::get();
       return $this->apiResponse(200 , null , $data);
    }


   public function get_moto_engine_brand()
    {
       $data = MotoEngineBrand::get();
       return $this->apiResponse(200 , null , $data);
      
    }

    public function get_moto_engine_model(Request $request)
    {
       $moto_models = MotoStock::where('make_id',$request->make_id)->where('year_id',$request->year_id)->pluck('model_id');
       
       $data =  MotoEngineModel::whereIn('id',$moto_models)->get();
       
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_engine_year(Request $request)
    {
       
       $moto_years = MotoStock::where('make_id',$request->make_id)->pluck('year_id');
       
       $data =  MotoEngineYear::whereIn('id',$moto_years)->get();
       
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_final_drive()
    {
       $data = MotoFinalDrive::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_fork()
    {
       $data = MotoFork::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_fuelinjector()
    {
       $data = MotoFuelinjector::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_fuel_management()
    {
       $data = MotoFuelManagement::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_header()
    {
       $data = MotoHeader::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_hyper_charge()
    {
       $data = MotoHyperCharge::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_ignition()
    {
       $data = MotoIgnition::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_lowering_link()
    {
       $data = MotoLoweringLink::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_manifold()
    {
       $data = MotoManifold::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_na_super_chrage_turbo()
    {
       $data = MotoNaSuperChrageTurbo::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_nos()
    {
       $data = MotoNos::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_pipe()
    {
       $data = MotoPipe::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_piston()
    {
       $data = MotoPiston::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_primary_drive()
    {
       $data = MotoPrimaryDrive::get();
       return $this->apiResponse(200 , null , $data);
    }
    
    
     public function get_super_charge_kit()
    {
       $data = MotoShock::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_rims_brand()
    {
       $data = MotoRimsBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_rims_size()
    {
       $data = MotoRimsSize::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_seat()
    {
       $data = MotoSeat::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_shock()
    {
       $data = MotoShock::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_silpone()
    {
       $data = MotoSilpone::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_sprocket()
    {
       $data = MotoSprocket::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_tires_brand()
    {
       $data = MotoTiresBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_turbo_kit()
    {
       $data = MotoTurboKit::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_valve()
    {
       $data = MotoValve::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_moto_westgate()
    {
       $data = MotoWestgate::get();
       return $this->apiResponse(200 , null , $data);
    }





    
       public function update_moto(Request $request)
    {
           $user = auth()->user();

        if($request->moto_air_filter_id == -1){
           $moto_air_filter_id = MotoAirFilter::create(['name'=> $request->moto_air_filter , 'status' => 0])->id;
        } else {
           $moto_air_filter_id = $request->moto_air_filter_id;
        }


        if($request->moto_blow_of_valve_id == -1){
           $moto_blow_of_valve_id = MotoBlowOfValve::create(['name'=> $request->other_moto_blow_of_valve , 'status' => 0])->id;
        } else {
           $moto_blow_of_valve_id = $request->moto_blow_of_valve_id;
        }


        if($request->moto_boost_controller_id == -1){
           $moto_boost_controller_id = MotoBoostController::create(['name'=> $request->other_moto_boost_controller , 'status' => 0])->id;
        } else {
           $moto_boost_controller_id = $request->moto_boost_controller_id;
        }


        if($request->moto_brake_line_id == -1){
           $moto_brake_line_id = MotoBrakeLine::create(['name'=> $request->other_moto_brake_line , 'status' => 0])->id;
        } else {
           $moto_brake_line_id = $request->moto_brake_line_id;
        }


        if($request->moto_brake_master_cylinder_id == -1){
           $moto_brake_master_cylinder_id = MotoBrakeMasterCylinder::create(['name'=> $request->other_moto_brake_master_cylinder , 'status' => 0])->id;
        } else {
           $moto_brake_master_cylinder_id = $request->moto_brake_master_cylinder_id;
        }


        if($request->moto_brake_pad_id == -1){
           $moto_brake_pad_id = MotoBrakePad::create(['name'=> $request->other_moto_brake_pad , 'status' => 0])->id;
        } else {
           $moto_brake_pad_id = $request->moto_brake_pad_id;
        }


        if($request->moto_brake_rotor_id == -1){
           $moto_brake_rotor_id = MotoBrakeRotor::create(['name'=> $request->other_moto_brake_rotor , 'status' => 0])->id;
        } else {
           $moto_brake_rotor_id = $request->moto_brake_rotor_id;
        }


        if($request->moto_caliper_id == -1){
           $moto_caliper_id = MotoCaliper::create(['name'=> $request->other_moto_caliper , 'status' => 0])->id;
        } else {
           $moto_caliper_id = $request->moto_caliper_id;
        }


        if($request->moto_cam_shaft_id == -1){
           $moto_cam_shaft_id = MotoCamShaft::create(['name'=> $request->other_moto_cam_shaft , 'status' => 0])->id;
        } else {
           $moto_cam_shaft_id = $request->moto_cam_shaft_id;
        }


        if($request->moto_clutch_id == -1){
           $moto_clutch_id = MotoClutch::create(['name'=> $request->other_moto_clutch_id , 'status' => 0])->id;
        } else {
           $moto_clutch_id = $request->moto_clutch_id;
        }

        if($request->moto_connecting_rod_id == -1){
           $moto_connecting_rod_id = MotoConnectingRod::create(['name'=> $request->other_moto_connecting_rod , 'status' => 0])->id;
        } else {
           $moto_connecting_rod_id = $request->moto_connecting_rod_id;
        }


        if($request->moto_control_id == -1){
           $moto_control_id = MotoControl::create(['name'=> $request->other_moto_control , 'status' => 0])->id;
        } else {
           $moto_control_id = $request->moto_control_id;
        }


        if($request->moto_cooling_system_id == -1){
           $moto_cooling_system_id = MotoCoolingSystem::create(['name'=> $request->other_moto_cooling_system , 'status' => 0])->id;
        } else {
           $moto_cooling_system_id = $request->moto_cooling_system_id;
        }


        if($request->moto_crank_shaft_id == -1){
           $moto_crank_shaft_id = MotoCrankShaft::create(['name'=> $request->other_moto_crank_shaft , 'status' => 0])->id;
        } else {
           $moto_crank_shaft_id = $request->moto_crank_shaft_id;
        }


        if($request->moto_crash_bar_id == -1){
           $moto_crash_bar_id = MotoCrashBar::create(['name'=> $request->other_moto_crash_bar , 'status' => 0])->id;
        } else {
           $moto_crash_bar_id = $request->moto_crash_bar_id;
        }


        if($request->moto_ecu_id == -1){
           $moto_ecu_id = MotoEcu::create(['name'=> $request->other_moto_ecu , 'status' => 0])->id;
        } else {
           $moto_ecu_id = $request->moto_ecu_id;
        }


        if($request->moto_engine_brand_id == -1){
           $moto_engine_brand_id = MotoEngineBrand::create(['name'=> $request->other_moto_engine_brand , 'status' => 0])->id;
        } else {
           $moto_engine_brand_id = $request->moto_engine_brand_id;
        }


        if($request->moto_engine_guard_id == -1){
           $moto_engine_guard_id = MotoEngineGuard::create(['name'=> $request->other_moto_engine_guard , 'status' => 0])->id;
        } else {
           $moto_engine_guard_id = $request->moto_engine_guard_id;
        }


        if($request->moto_engine_model_id == -1){
           $moto_engine_model_id = MotoEngineModel::create(['name'=> $request->other_moto_engine_model , 'status' => 0])->id;
        } else {
           $moto_engine_model_id = $request->moto_engine_model_id;
        }


        if($request->moto_engine_year_id == -1){
           $moto_engine_year_id = MotoEngineYear::create(['name'=> $request->other_moto_engine_year , 'status' => 0])->id;
        } else {
           $moto_engine_year_id = $request->moto_engine_year_id;
        }


        if($request->moto_final_drive_id == -1){
            $moto_final_drive_id = MotoFinalDrive::create(['name'=> $request->other_moto_final_drive , 'status' => 0])->id;
         } else {
            $moto_final_drive_id = $request->moto_final_drive_id;
         }



        if($request->moto_fork_id == -1){
            $moto_fork_id = MotoFork::create(['name'=> $request->other_moto_fork , 'status' => 0])->id;
         } else {
            $moto_fork_id = $request->moto_fork_id;
         }



        if($request->moto_fuelinjector_id == -1){
            $moto_fuelinjector_id = MotoFuelinjector::create(['name'=> $request->other_moto_fuelinjector , 'status' => 0])->id;
         } else {
            $moto_fuelinjector_id = $request->moto_fuelinjector_id;
         }


        if($request->moto_fuel_management_id == -1){
            $moto_fuel_management_id = MotoFuelManagement::create(['name'=> $request->other_moto_fuel_management , 'status' => 0])->id;
         } else {
            $moto_fuel_management_id = $request->moto_fuel_management_id;
         }

        if($request->moto_header_id == -1){
            $moto_header_id = MotoHeader::create(['name'=> $request->other_moto_header , 'status' => 0])->id;
         } else {
            $moto_header_id = $request->moto_header_id;
         }


        if($request->moto_hyper_charge_id == -1){
            $moto_hyper_charge_id = MotoHyperCharge::create(['name'=> $request->other_moto_hyper_charge , 'status' => 0])->id;
         } else {
            $moto_hyper_charge_id = $request->moto_hyper_charge_id;
         }



        if($request->moto_ignition_id == -1){
            $moto_ignition_id = MotoIgnition::create(['name'=> $request->other_moto_ignition , 'status' => 0])->id;
         } else {
            $moto_ignition_id = $request->moto_ignition_id;
         }



        if($request->moto_lowering_link_id == -1){
            $moto_lowering_link_id = MotoLoweringLink::create(['name'=> $request->other_moto_lowering_link , 'status' => 0])->id;
         } else {
            $moto_lowering_link_id = $request->moto_lowering_link_id;
         }


        if($request->moto_manifold_id == -1){
            $moto_manifold_id = MotoManifold::create(['name'=> $request->other_engimoto_manifold , 'status' => 0])->id;
         } else {
            $moto_manifold_id = $request->moto_manifold_id;
         }


        if($request->moto_na_super_chrage_turbo_id == -1){
            $moto_na_super_chrage_turbo_id = MotoNaSuperChrageTurbo::create(['name'=> $request->other_moto_na_super_chrage_turbo , 'status' => 0])->id;
         } else {
            $moto_na_super_chrage_turbo_id = $request->moto_na_super_chrage_turbo_id;
         }


        if($request->moto_nos_id == -1){
            $moto_nos_id = MotoNos::create(['name'=> $request->other_moto_nos , 'status' => 0])->id;
         } else {
            $moto_nos_id = $request->moto_nos_id;
         }


        if($request->moto_pipe_id == -1){
            $moto_pipe_id = MotoPipe::create(['name'=> $request->other_moto_pipe , 'status' => 0])->id;
         } else {
            $moto_pipe_id = $request->moto_pipe_id;
         }


        if($request->moto_piston_id == -1){
            $moto_piston_id = MotoPiston::create(['name'=> $request->other_moto_piston_id , 'status' => 0])->id;
         } else {
            $moto_piston_id = $request->moto_piston_id;
         }


        if($request->moto_primary_drive_id == -1){
            $moto_primary_drive_id = MotoPrimaryDrive::create(['name'=> $request->other_moto_primary_drive , 'status' => 0])->id;
         } else {
            $moto_primary_drive_id = $request->moto_primary_drive_id;
         }

        if($request->moto_rims_brand_id == -1){
            $moto_rims_brand_id = MotoRimsBrand::create(['name'=> $request->other_moto_rims_brand , 'status' => 0])->id;
         } else {
            $moto_rims_brand_id = $request->moto_rims_brand_id;
         }


        if($request->moto_rims_size_id == -1){
            $moto_rims_size_id = MotoRimsSize::create(['name'=> $request->other_moto_rims_size , 'status' => 0])->id;
         } else {
            $moto_rims_size_id = $request->moto_rims_size_id;
         }


        if($request->moto_seat_id == -1){
            $moto_seat_id = MotoSeat::create(['name'=> $request->other_moto_seat , 'status' => 0])->id;
         } else {
            $moto_seat_id = $request->moto_seat_id;
         }


        if($request->moto_shock_id == -1){
            $moto_shock_id = MotoShock::create(['name'=> $request->other_moto_shock , 'status' => 0])->id;
         } else {
            $moto_shock_id = $request->moto_shock_id;
         }


        if($request->moto_silpone_id == -1){
            $moto_silpone_id = MotoSilpone::create(['name'=> $request->other_moto_silpone , 'status' => 0])->id;
         } else {
            $moto_silpone_id = $request->moto_silpone_id;
         }


        if($request->moto_sprocket_id == -1){
            $moto_sprocket_id = MotoSprocket::create(['name'=> $request->other_moto_sprocket , 'status' => 0])->id;
         } else {
            $moto_sprocket_id = $request->moto_sprocket_id;
         }


        if($request->moto_tires_brand_id == -1){
            $moto_tires_brand_id = MotoTiresBrand::create(['name'=> $request->other_moto_tires_brand , 'status' => 0])->id;
         } else {
            $moto_tires_brand_id = $request->moto_tires_brand_id;
         }


        if($request->moto_turbo_kit_id == -1){
            $moto_turbo_kit_id = MotoTurboKit::create(['name'=> $request->other_moto_turbo_kit , 'status' => 0])->id;
         } else {
            $moto_turbo_kit_id = $request->moto_turbo_kit_id;
         }


        if($request->moto_valve_id == -1){
            $moto_valve_id = MotoValve::create(['name'=> $request->other_moto_valve , 'status' => 0])->id;
         } else {
            $moto_valve_id = $request->moto_valve_id;
         }


        if($request->moto_westgate_id == -1){
            $moto_westgate_id = MotoWestgate::create(['name'=> $request->other_moto_westgate , 'status' => 0])->id;
         } else {
            $moto_westgate_id = $request->moto_westgate_id;
         }



            $moto = Moto::where('id',$request->moto_id)->first();
        
            if($moto_cooling_system_id)
            $moto->moto_cooling_system_id =  $moto_cooling_system_id ;
            if($moto_ecu_id)
            $moto->moto_ecu_id =  $moto_ecu_id ;
            
            
            
             if($request->moto_brand_id){
            $moto->moto_brand_id =  $request->moto_brand_id ;
             }
            
            if($request->moto_engine_year_id){
            $moto->moto_year_id =  $request->moto_year_id ;
            }
            
            if($request->moto_model_id){
            $moto->moto_model_id =  $request->moto_model_id ;
            }
            
            
            if($moto_engine_brand_id)
            $moto->moto_engine_brand_id =  $moto_engine_brand_id ;
            if($moto_engine_year_id)
            $moto->moto_engine_year_id =  $moto_engine_year_id ;
            if($moto_engine_model_id)
            $moto->moto_engine_model_id =  $moto_engine_model_id ;
            if($moto_cooling_system_id)
            $moto->moto_cooling_system_id =  $moto_cooling_system_id ;
            if($moto_nos_id)
            $moto->moto_nos_id =  $moto_nos_id ;
            if($moto_na_super_chrage_turbo_id)
            $moto->moto_na_super_chrage_turbo_id =  $moto_na_super_chrage_turbo_id ;
            if($moto_turbo_kit_id)
            $moto->moto_turbo_kit_id =  $moto_turbo_kit_id ;
            if($moto_westgate_id)
            $moto->moto_blow_of_valve_id =  $moto_westgate_id ;
            if($moto_boost_controller_id)
            $moto->moto_boost_controller_id =  $moto_boost_controller_id ;
            if($moto_cam_shaft_id)
            $moto->moto_cam_shaft_id =  $moto_cam_shaft_id ;
            if($moto_ignition_id)
            $moto->moto_connecting_rod_id =  $moto_ignition_id ;
            if($moto_piston_id)
            $moto->moto_piston_id =  $moto_piston_id ;
            if($moto_crank_shaft_id)
            $moto->moto_crank_shaft_id =  $moto_crank_shaft_id ;
            if($moto_connecting_rod_id)
            $moto->moto_manifold_id =  $moto_connecting_rod_id ;
            if($moto_final_drive_id)
            $moto->moto_final_drive_id =  $moto_final_drive_id ;
            if($moto_sprocket_id)
            $moto->moto_sprocket_id =  $moto_sprocket_id ;
            if($moto_primary_drive_id)
            $moto->moto_primary_drive_id =  $moto_primary_drive_id ;
            if($moto_primary_drive_id)
            $moto->moto_brake_line_id =  $moto_brake_line_id ;
            if($moto_brake_master_cylinder_id)
            $moto->moto_brake_master_cylinder_id =  $moto_brake_master_cylinder_id ;
            if($moto_brake_pad_id)
            $moto->moto_brake_pad_id =  $moto_brake_pad_id ;
            if($moto_brake_rotor_id)
            $moto->moto_brake_rotor_id =  $moto_brake_rotor_id ;
            if($moto_caliper_id)
            $moto->moto_caliper_id =  $moto_caliper_id ;
            if($moto_fork_id)
            $moto->moto_fork_id =  $moto_fork_id ;
            if($moto_lowering_link_id)
            $moto->moto_lowering_link_id =  $moto_lowering_link_id ;
            if($moto_shock_id)
            $moto->moto_shock_id =  $moto_shock_id ;
            if($moto_fuelinjector_id)
            $moto->moto_fuelinjector_id =  $moto_fuelinjector_id ;
            if($moto_fuel_management_id)
            $moto->moto_fuel_management_id =  $moto_fuel_management_id ;
            if($moto_tires_brand_id)
            $moto->moto_tires_brand_id =  $moto_tires_brand_id ;
            if($moto_rims_size_id)
            $moto->moto_rims_size_id =  $moto_rims_size_id ;
            if($moto_rims_brand_id)
            $moto->moto_rims_brand_id =  $moto_rims_brand_id ;
            if($moto_air_filter_id)
            $moto->moto_air_filter_id =  $moto_air_filter_id ;
            if($moto_hyper_charge_id)
            $moto->moto_hyper_charge_id =  $moto_hyper_charge_id ;
            if($moto_control_id)
            $moto->moto_control_id =  $moto_control_id ;
            if($moto_crash_bar_id)
            $moto->moto_crash_bar_id =  $moto_crash_bar_id ;
            if($moto_engine_guard_id)
            $moto->moto_engine_guard_id =  $moto_engine_guard_id ;
            if($moto_seat_id)
            $moto->moto_seat_id =  $moto_seat_id ;
            if($moto_header_id)
            $moto->moto_header_id =  $moto_header_id ;
            if($moto_pipe_id)
            $moto->moto_pipe_id =  $moto_pipe_id ;
            if($moto_silpone_id)
            $moto->moto_silpone_id =  $moto_silpone_id ;
    
            
             if($request->modified_max_speed)
            $moto->modified_max_speed =  $request->modified_max_speed ;
             if($request->modified_torque)
            $moto->modified_torque =  $request->modified_torque ;
             if($request->modified_zero_hundred)
            $moto->modified_zero_hundred =  $request->modified_zero_hundred ;
             if($request->modified_hourse_power)
            $moto->modified_hourse_power =  $request->modified_hourse_power ;
            
            
       
            $moto->data_cache =  $request->data_cache ;
            
  
        $moto->save();
        
        
         $von_text = $user->name." has now updated their motorcycle";
     
          
       VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $moto->id , 'von_type' => 'create_car' ]);
       

        if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        $moto->image = $image_name;
        $moto->save();
        }

        return $this->apiResponse(200 , null , $moto);
    }


    public function save_moto(Request $request)
    {
           $user = auth()->user();

        if($request->moto_air_filter_id == -1){
           $moto_air_filter_id = MotoAirFilter::create(['name'=> $request->moto_air_filter , 'status' => 0])->id;
        } else {
           $moto_air_filter_id = $request->moto_air_filter_id;
        }


        if($request->moto_blow_of_valve_id == -1){
           $moto_blow_of_valve_id = MotoBlowOfValve::create(['name'=> $request->other_moto_blow_of_valve , 'status' => 0])->id;
        } else {
           $moto_blow_of_valve_id = $request->moto_blow_of_valve_id;
        }


        if($request->moto_boost_controller_id == -1){
           $moto_boost_controller_id = MotoBoostController::create(['name'=> $request->other_moto_boost_controller , 'status' => 0])->id;
        } else {
           $moto_boost_controller_id = $request->moto_boost_controller_id;
        }


        if($request->moto_brake_line_id == -1){
           $moto_brake_line_id = MotoBrakeLine::create(['name'=> $request->other_moto_brake_line , 'status' => 0])->id;
        } else {
           $moto_brake_line_id = $request->moto_brake_line_id;
        }


        if($request->moto_brake_master_cylinder_id == -1){
           $moto_brake_master_cylinder_id = MotoBrakeMasterCylinder::create(['name'=> $request->other_moto_brake_master_cylinder , 'status' => 0])->id;
        } else {
           $moto_brake_master_cylinder_id = $request->moto_brake_master_cylinder_id;
        }


        if($request->moto_brake_pad_id == -1){
           $moto_brake_pad_id = MotoBrakePad::create(['name'=> $request->other_moto_brake_pad , 'status' => 0])->id;
        } else {
           $moto_brake_pad_id = $request->moto_brake_pad_id;
        }


        if($request->moto_brake_rotor_id == -1){
           $moto_brake_rotor_id = MotoBrakeRotor::create(['name'=> $request->other_moto_brake_rotor , 'status' => 0])->id;
        } else {
           $moto_brake_rotor_id = $request->moto_brake_rotor_id;
        }


        if($request->moto_caliper_id == -1){
           $moto_caliper_id = MotoCaliper::create(['name'=> $request->other_moto_caliper , 'status' => 0])->id;
        } else {
           $moto_caliper_id = $request->moto_caliper_id;
        }


        if($request->moto_cam_shaft_id == -1){
           $moto_cam_shaft_id = MotoCamShaft::create(['name'=> $request->other_moto_cam_shaft , 'status' => 0])->id;
        } else {
           $moto_cam_shaft_id = $request->moto_cam_shaft_id;
        }


        if($request->moto_clutch_id == -1){
           $moto_clutch_id = MotoClutch::create(['name'=> $request->other_moto_clutch_id , 'status' => 0])->id;
        } else {
           $moto_clutch_id = $request->moto_clutch_id;
        }

        if($request->moto_connecting_rod_id == -1){
           $moto_connecting_rod_id = MotoConnectingRod::create(['name'=> $request->other_moto_connecting_rod , 'status' => 0])->id;
        } else {
           $moto_connecting_rod_id = $request->moto_connecting_rod_id;
        }


        if($request->moto_control_id == -1){
           $moto_control_id = MotoControl::create(['name'=> $request->other_moto_control , 'status' => 0])->id;
        } else {
           $moto_control_id = $request->moto_control_id;
        }


        if($request->moto_cooling_system_id == -1){
           $moto_cooling_system_id = MotoCoolingSystem::create(['name'=> $request->other_moto_cooling_system , 'status' => 0])->id;
        } else {
           $moto_cooling_system_id = $request->moto_cooling_system_id;
        }


        if($request->moto_crank_shaft_id == -1){
           $moto_crank_shaft_id = MotoCrankShaft::create(['name'=> $request->other_moto_crank_shaft , 'status' => 0])->id;
        } else {
           $moto_crank_shaft_id = $request->moto_crank_shaft_id;
        }


        if($request->moto_crash_bar_id == -1){
           $moto_crash_bar_id = MotoCrashBar::create(['name'=> $request->other_moto_crash_bar , 'status' => 0])->id;
        } else {
           $moto_crash_bar_id = $request->moto_crash_bar_id;
        }


        if($request->moto_ecu_id == -1){
           $moto_ecu_id = MotoEcu::create(['name'=> $request->other_moto_ecu , 'status' => 0])->id;
        } else {
           $moto_ecu_id = $request->moto_ecu_id;
        }


        if($request->moto_engine_brand_id == -1){
           $moto_engine_brand_id = MotoEngineBrand::create(['name'=> $request->other_moto_engine_brand , 'status' => 0])->id;
        } else {
           $moto_engine_brand_id = $request->moto_engine_brand_id;
        }


        if($request->moto_engine_guard_id == -1){
           $moto_engine_guard_id = MotoEngineGuard::create(['name'=> $request->other_moto_engine_guard , 'status' => 0])->id;
        } else {
           $moto_engine_guard_id = $request->moto_engine_guard_id;
        }


        if($request->moto_engine_model_id == -1){
           $moto_engine_model_id = MotoEngineModel::create(['name'=> $request->other_moto_engine_model , 'status' => 0])->id;
        } else {
           $moto_engine_model_id = $request->moto_engine_model_id;
        }


        if($request->moto_engine_year_id == -1){
           $moto_engine_year_id = MotoEngineYear::create(['name'=> $request->other_moto_engine_year , 'status' => 0])->id;
        } else {
           $moto_engine_year_id = $request->moto_engine_year_id;
        }


        if($request->moto_final_drive_id == -1){
            $moto_final_drive_id = MotoFinalDrive::create(['name'=> $request->other_moto_final_drive , 'status' => 0])->id;
         } else {
            $moto_final_drive_id = $request->moto_final_drive_id;
         }



        if($request->moto_fork_id == -1){
            $moto_fork_id = MotoFork::create(['name'=> $request->other_moto_fork , 'status' => 0])->id;
         } else {
            $moto_fork_id = $request->moto_fork_id;
         }



        if($request->moto_fuelinjector_id == -1){
            $moto_fuelinjector_id = MotoFuelinjector::create(['name'=> $request->other_moto_fuelinjector , 'status' => 0])->id;
         } else {
            $moto_fuelinjector_id = $request->moto_fuelinjector_id;
         }


        if($request->moto_fuel_management_id == -1){
            $moto_fuel_management_id = MotoFuelManagement::create(['name'=> $request->other_moto_fuel_management , 'status' => 0])->id;
         } else {
            $moto_fuel_management_id = $request->moto_fuel_management_id;
         }

        if($request->moto_header_id == -1){
            $moto_header_id = MotoHeader::create(['name'=> $request->other_moto_header , 'status' => 0])->id;
         } else {
            $moto_header_id = $request->moto_header_id;
         }


        if($request->moto_hyper_charge_id == -1){
            $moto_hyper_charge_id = MotoHyperCharge::create(['name'=> $request->other_moto_hyper_charge , 'status' => 0])->id;
         } else {
            $moto_hyper_charge_id = $request->moto_hyper_charge_id;
         }



        if($request->moto_ignition_id == -1){
            $moto_ignition_id = MotoIgnition::create(['name'=> $request->other_moto_ignition , 'status' => 0])->id;
         } else {
            $moto_ignition_id = $request->moto_ignition_id;
         }



        if($request->moto_lowering_link_id == -1){
            $moto_lowering_link_id = MotoLoweringLink::create(['name'=> $request->other_moto_lowering_link , 'status' => 0])->id;
         } else {
            $moto_lowering_link_id = $request->moto_lowering_link_id;
         }


        if($request->moto_manifold_id == -1){
            $moto_manifold_id = MotoManifold::create(['name'=> $request->other_engimoto_manifold , 'status' => 0])->id;
         } else {
            $moto_manifold_id = $request->moto_manifold_id;
         }


        if($request->moto_na_super_chrage_turbo_id == -1){
            $moto_na_super_chrage_turbo_id = MotoNaSuperChrageTurbo::create(['name'=> $request->other_moto_na_super_chrage_turbo , 'status' => 0])->id;
         } else {
            $moto_na_super_chrage_turbo_id = $request->moto_na_super_chrage_turbo_id;
         }


        if($request->moto_nos_id == -1){
            $moto_nos_id = MotoNos::create(['name'=> $request->other_moto_nos , 'status' => 0])->id;
         } else {
            $moto_nos_id = $request->moto_nos_id;
         }


        if($request->moto_pipe_id == -1){
            $moto_pipe_id = MotoPipe::create(['name'=> $request->other_moto_pipe , 'status' => 0])->id;
         } else {
            $moto_pipe_id = $request->moto_pipe_id;
         }


        if($request->moto_piston_id == -1){
            $moto_piston_id = MotoPiston::create(['name'=> $request->other_moto_piston_id , 'status' => 0])->id;
         } else {
            $moto_piston_id = $request->moto_piston_id;
         }


        if($request->moto_primary_drive_id == -1){
            $moto_primary_drive_id = MotoPrimaryDrive::create(['name'=> $request->other_moto_primary_drive , 'status' => 0])->id;
         } else {
            $moto_primary_drive_id = $request->moto_primary_drive_id;
         }

        if($request->moto_rims_brand_id == -1){
            $moto_rims_brand_id = MotoRimsBrand::create(['name'=> $request->other_moto_rims_brand , 'status' => 0])->id;
         } else {
            $moto_rims_brand_id = $request->moto_rims_brand_id;
         }


        if($request->moto_rims_size_id == -1){
            $moto_rims_size_id = MotoRimsSize::create(['name'=> $request->other_moto_rims_size , 'status' => 0])->id;
         } else {
            $moto_rims_size_id = $request->moto_rims_size_id;
         }


        if($request->moto_seat_id == -1){
            $moto_seat_id = MotoSeat::create(['name'=> $request->other_moto_seat , 'status' => 0])->id;
         } else {
            $moto_seat_id = $request->moto_seat_id;
         }


        if($request->moto_shock_id == -1){
            $moto_shock_id = MotoShock::create(['name'=> $request->other_moto_shock , 'status' => 0])->id;
         } else {
            $moto_shock_id = $request->moto_shock_id;
         }


        if($request->moto_silpone_id == -1){
            $moto_silpone_id = MotoSilpone::create(['name'=> $request->other_moto_silpone , 'status' => 0])->id;
         } else {
            $moto_silpone_id = $request->moto_silpone_id;
         }


        if($request->moto_sprocket_id == -1){
            $moto_sprocket_id = MotoSprocket::create(['name'=> $request->other_moto_sprocket , 'status' => 0])->id;
         } else {
            $moto_sprocket_id = $request->moto_sprocket_id;
         }


        if($request->moto_tires_brand_id == -1){
            $moto_tires_brand_id = MotoTiresBrand::create(['name'=> $request->other_moto_tires_brand , 'status' => 0])->id;
         } else {
            $moto_tires_brand_id = $request->moto_tires_brand_id;
         }


        if($request->moto_turbo_kit_id == -1){
            $moto_turbo_kit_id = MotoTurboKit::create(['name'=> $request->other_moto_turbo_kit , 'status' => 0])->id;
         } else {
            $moto_turbo_kit_id = $request->moto_turbo_kit_id;
         }


        if($request->moto_valve_id == -1){
            $moto_valve_id = MotoValve::create(['name'=> $request->other_moto_valve , 'status' => 0])->id;
         } else {
            $moto_valve_id = $request->moto_valve_id;
         }


        if($request->moto_westgate_id == -1){
            $moto_westgate_id = MotoWestgate::create(['name'=> $request->other_moto_westgate , 'status' => 0])->id;
         } else {
            $moto_westgate_id = $request->moto_westgate_id;
         }



        $moto = Moto::create([
            'stock'=>$request->stock ,
            'moto_cooling_system_id' => $moto_cooling_system_id ,
            'moto_ecu_id' => $moto_ecu_id ,
            
             'moto_brand_id' => $request->moto_brand_id ,
            'moto_year_id' => $request->moto_year_id ,
            'moto_model_id' => $request->moto_model_id ,
            
            'moto_engine_brand_id' => $moto_engine_brand_id ,
            'moto_engine_year_id' => $moto_engine_year_id ,
            'moto_engine_model_id' => $moto_engine_model_id ,
            'moto_nos_id' => $moto_nos_id ,
            'moto_na_super_chrage_turbo_id' => $moto_na_super_chrage_turbo_id ,
            'moto_turbo_kit_id' => $moto_turbo_kit_id ,
            'moto_blow_of_valve_id' => $moto_blow_of_valve_id ,
            'moto_westgate_id' => $moto_westgate_id ,
            'moto_boost_controller_id' => $moto_boost_controller_id ,
            'moto_cam_shaft_id' => $moto_cam_shaft_id ,
            'moto_valve_id' => $moto_valve_id ,
            'moto_connecting_rod_id' => $moto_connecting_rod_id ,
            'moto_ignition_id' => $moto_ignition_id ,
            'moto_piston_id' => $moto_piston_id ,
            'moto_crank_shaft_id' => $moto_crank_shaft_id ,
            'moto_manifold_id' => $moto_manifold_id ,
            'moto_clutch_id' => $moto_clutch_id ,
            'moto_final_drive_id' => $moto_final_drive_id ,
            'moto_sprocket_id' => $moto_sprocket_id ,
            'moto_primary_drive_id' => $moto_primary_drive_id ,
            'moto_brake_line_id' => $moto_brake_line_id ,
            'moto_brake_master_cylinder_id' => $moto_brake_master_cylinder_id ,
            'moto_brake_pad_id'  => $moto_brake_pad_id ,
            'moto_brake_rotor_id' => $moto_brake_rotor_id ,
            'moto_caliper_id' => $moto_caliper_id ,
            'moto_fork_id' => $moto_fork_id ,
            'moto_lowering_link_id' => $moto_lowering_link_id  ,
            'moto_shock_id' => $moto_shock_id ,
            'moto_fuelinjector_id' => $moto_fuelinjector_id ,
            'moto_fuel_management_id' => $moto_fuel_management_id ,
            'moto_tires_brand_id' => $moto_tires_brand_id ,
            'moto_rims_size_id' => $moto_rims_size_id ,
            'moto_rims_brand_id' => $moto_rims_brand_id ,
            'moto_air_filter_id' => $moto_air_filter_id ,
            'moto_hyper_charge_id' => $moto_hyper_charge_id ,
            'moto_control_id' => $moto_control_id ,
            'moto_crash_bar_id' => $moto_crash_bar_id ,
            'moto_engine_guard_id' => $moto_engine_guard_id ,
            'moto_seat_id' => $moto_seat_id ,
            'moto_header_id' => $moto_header_id ,
            'moto_pipe_id' => $moto_pipe_id ,
            'moto_silpone_id' => $moto_silpone_id ,
            'modified_max_speed' => $request->modified_max_speed ,
            'modified_torque' => $request->modified_torque ,
            'modified_zero_hundred' => $request->modified_zero_hundred ,
            'modified_hourse_power' => $request->modified_hourse_power ,
            'data_cache' => $request->data_cache ,
            
          ]);

        $moto->user_id =  $user->id;
        $moto->save();
        
        
         $von_text = $user->name." has now added their stock motocycle";
     
     
     if($request->stock==1){
        $von_text =  $user->name." has now added their stock motocycle";
     }
          
       VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $moto->id , 'von_type' => 'create_car' ]);
       

        if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        $moto->image = $image_name;
        $moto->save();
        }

        return $this->apiResponse(200 , null , $moto);
    }
    
    
     public function get_motos(Request $request)
    {
        
       $motos = Moto::where('user_id',$request->user_id)->get();

       foreach($motos as $moto){
           
        
            $moto->image = asset('images/').'/'.$moto->image;
            
            $moto_stock = MotoStock::where('make_id',$moto->moto_engine_brand_id)->where('year_id',$moto->moto_engine_year_id)->where('model_id',$moto->moto_engine_model_id)
            ->first();
            
            
                
           
            //dd($moto_stock);
                  $moto_make =  MotoEngineBrand::select('name')->where('id',$moto_stock->make_id)->first()->name;
                  
                      
                      
                  
                  $moto_year = MotoEngineYear::select('name')->where('id',$moto_stock->year_id)->first()->name;
                  
                      
               
                      
                  $moto_model =  MotoEngineModel::select('name')->where('id',$moto_stock->model_id)->first()->name;
                  
                
                       
                  
                  $moto_category =  MotoCategory::select('name')->where('id',$moto_stock->category_id)->first()->name;
                  
            
                  $moto_displacement = MotoDisplacement::select('name')->where('id',$moto_stock->displacement_id)->first()->name;
                  
                  $moto_engine_details = MotoEngineDetails::select('name')->where('id',$moto_stock->engine_details_id)->first()->name;
                  
                
                  $moto_power = MotoPower::select('name')->where('id',$moto_stock->power_id)->first()->name;
                  
                  $moto_power_rpm = MotoPowerRpm::select('name')->where('id',$moto_stock->power_rpm_id)->first()->name;
                  
                  $moto_torque = MotoTorque::select('name')->where('id',$moto_stock->torque_id)->first()->name;
                  
                  
                  $moto_torque_rpm = MotoTorqueRpm::select('name')->where('id',$moto_stock->torque_rpm_id)->first()->name;
                  
                  $moto_zero_hundred = MotoZeroOne::select('name')->where('id',$moto_stock->zero_hundred_id)->first()->name;
                  
                  $moto_compression = MotoCompression::select('name')->where('id',$moto_stock->compression_id)->first()->name;
                  
                  $moto_stroke = MotoStroke::select('name')->where('id',$moto_stock->stroke_id)->first()->name;
                  
                  $moto_valves_per_cylinder = MotoValvesPerCylinder::select('name')->where('id',$moto_stock->valves_id)->first()->name;
                 
                  $moto_gear_box = MotoGearBox::select('name')->where('id',$moto_stock->gear_box_id)->first()->name;
                  
                  $moto_transimission_type = MotoTransmissionType::select('name')->where('id',$moto_stock->transimission_id)->first()->name;
                  
                   $moto_weight = MotoWeight::select('name')->where('id',$moto_stock->weight_id)->first()->name;
                   
                   
                    $moto_top_speed = MotoTopSpeed::select('name')->where('id',$moto_stock->top_speed_id)->first()->name;
                    
                    $cooling_system  = MotoCoolingSystem::select('name')->where('id',$moto_stock->cooling_system_id)->first()->name;
                   
                   
                 
        
                   
                   $moto->snario = $moto_make." ,".$moto_model." , ".$moto_year." , ".$moto_category.",".$moto_engine_details.",".$moto_power
                   
                   .",".$moto_power_rpm
                   .",".$moto_torque
                   .",".$moto_torque_rpm
                   .",".$moto_top_speed
                   .",".$moto_compression
                   .",".$moto_stroke
                   .",".$moto_valves_per_cylinder
                   .",".$cooling_system
                   .",".$moto_gear_box
                   .",".$moto_transimission_type;
                   
            //       if($car->modified_engine_cc){
            //           $car_engine_cc = $car->modified_engine_cc;
            //       }
                   
            //       if($car->modified_hourse_power){
            //           $car_horse_power = $car->modified_hourse_power;
            //       }
                   
            //       if($car->modified_max_speed){
            //           $car_max_speed = $car->modified_max_speed;
            //       }
                   
                   
            //       if($car->modified_torque){
            //           $car_torque = $car->modified_torque;
            //       }
                   
            //       if($car->modified_zero_hundred){
            //           $car_zero_hundred = $car->modified_zero_hundred;
            //       }
                   
                
            
            
            
            
            
       }
       
       

       return $this->apiResponse(200 , null , $motos);
    }
    
    
     public function get_moto_details(Request $request)
    {
       $moto = Moto::where('id',$request->moto_id)->first();
       $moto->image = asset('images/').'/'.$moto->image;
       
       return $this->apiResponse(200 , null , $moto);
    }



    public function remove_moto(Request $request)
    {
        $moto = Moto::where('id',$request->moto_id)->first();
        $moto->delete();
        return $this->apiResponse(200, 'moto is removed', null);
    }


}



