<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\SearchResource;
use App\Http\Resources\UserResource;
use App\Models\City;
use App\Models\Country;
use App\Models\Nationality;
use App\Models\Notification;
use App\Models\Region;
use App\Models\User;
use App\Models\Team;
use App\Models\TeamMember;
use App\Models\VonHistory;
use App\Models\Venue;
use App\Models\VenueEvent;
use App\Models\Club;
use App\Models\TeamParticipation;
use App\Models\VenueMember;
use App\Models\Academy;
use App\Models\Course;
use App\Models\Event;
use App\Models\VenueEventMember;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    public function update_profile(Request $request)
    {
        $user = auth()->user();
        
        
        $user->update($request->all());
        
        
     if($request->password != null){
        $user->password = Hash::make($request->password);
        $user->save();
        }
        $user['age'] = Carbon::parse($user['birthdate'])->age;
        
        
        
        // VonHistory::create(['user_id' => $user->id , 'text' => "Profile Updated" , 'von_id' => $user->id , 'von_type' => 'update_profile']);



        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function update_image(Request $request)
    {

        if($request->hasFile('image')){
            $image = $request->file('image');
            $image_name = Time().'-'.$image->getClientOriginalName();
            $file_path = public_path().'/images';
            $image->move($file_path,$image_name);
        }

        $user = auth()->user();
        $user->update(['image'=> $image_name]);

    // VonHistory::create(['user_id' => $user->id , 'text' => "Updated profile image" , 'von_id' => $user->id , 'von_type' => 'update_profile_image','image'=>$image_name]);

        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function update_background_image(Request $request)
    {
        $user = auth()->user();
        if($request->hasFile('background_image')){

            $background_image = $request->file('background_image');
            $background_image_name = Time().'-'.$background_image->getClientOriginalName();
            $background_image_path = public_path().'/images';
            $background_image->move($background_image_path,$background_image_name);
        }

        $user = auth()->user();
        $user->update(['background_image'=> $background_image_name]);


    // VonHistory::create(['user_id' => $user->id , 'text' => "Updated background image" , 'von_id' => $user->id , 'von_type' => 'update_background_image','image'=>$background_image_name]);
   
        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function update_interests(Request $request)
    {
        $user = auth()->user();

        $user->interests()->sync($request->interests);

        return $this->apiResponse(200 , null ,new UserResource($user));
    }


    public function notifications()
    {
        $user = auth()->user();
        $notifications = Notification::select('id','title','body','user_id','request_id','notification_type','created_at')->where('status',0)->where('user_id',$user->id)->orWhere('user_id',-1)->get();

        foreach($notifications as $notification){
            
            $notification->added_at = date('d-m-Y h:m',strtotime($notification->created_at))."";
            
                if($notification->notification_type == 35){
                $venue = VenueEvent::select('id','user_id')->where('id',$notification->request_id)->first();
                
                $notification->owner_id = $venue->user_id;
                
                }
            
        }
        return $this->apiResponse(200, null, $notifications);
    }
    
    
    
    public function update_notification(Request $request)
    {
        $user = auth()->user();
        
        $notification = Notification::where('id',$request->notification_id)->first();
        
        $notification->status = $request->status;
        
    
        
        $notification_title = "";
        $notification_body = "";
        $user_id = 0;
        
        if($notification->notification_type==1){
            
            
            $venue = Venue::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Best Record Venue";
                $notification_body = $user->name." accepted your request to be best record";
                
            }else {
                
                $notification_title = "Best Record Venue";
                $notification_body = $user->name." rejected your request to be best record";
                
            }
     
        
        
            
        }else if($notification->notification_type==2){
            
            
            $venue = Venue::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Venue Sponser";
                $notification_body = $user->name." accepted your request to be venue sponser ";
                
                
                     $venue_member =  VenueMember::where('venue_id',$venue->id)->where('member_id',$user->id)->first();
               $venue_member->status = 1;
               $venue_member->save();
               
                
            }else {
                
                $notification_title = "Venue Sponser";
                $notification_body = $user->name." rejected your request to be venue sponser ";
                
            }
     
        
        
            
        }else if($notification->notification_type==3){
            
            
            $venue = Venue::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Venue partner";
                $notification_body = $user->name." accepted your request to be venue partner";
                
                
               $venue_member =  VenueMember::where('venue_id',$venue->id)->where('member_id',$user->id)->first();
               $venue_member->status = 1;
               $venue_member->save();
                
                
            }else {
                
                $notification_title = "Venue partner";
                $notification_body = $user->name." rejected your request to be venue partner";
                
            }
            
            
        }else if($notification->notification_type==4){
            
            
            $venue = Venue::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Venue crew member";
                $notification_body = $user->name." accepted your request to be venue crew member";
                
                     $venue_member =  VenueMember::where('venue_id',$venue->id)->where('member_id',$user->id)->first();
               $venue_member->status = 1;
               $venue_member->save();
               
                
            }else {
                
                $notification_title = "Venue crew member";
                $notification_body = $user->name." rejected your request to be venue crew member";
                
            }
     
        
        
            
        }else if($notification->notification_type==5){
            
            
            $venue = VenueEvent::select('id','name','date','user_id')->where('id',$notification->request_id)->first();
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "venue event best record ";
                $notification_body = $user->name." accepted your request to be best record (".$venue->name.") (".$venue->date." )";
                
            }else {
                
                $notification_title = "Best Record Venue";
                           $notification_body = $user->name." rejected your request to be best record (".$venue->name.") (".$venue->date." )";
                
            }
     
        
        
            
        }else if($notification->notification_type==7){
            
            
            $venue = VenueEvent::select('id','name','date','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "venue event sponser";
                $notification_body = $user->name." accepted your request to be venue event sponser  (".$venue->name.") (".$venue->date." )";
                
            }else {
                
                $notification_title = "Best Record Venue";
                           $notification_body = $user->name." rejected your request to be venue event sponser (".$venue->name.") (".$venue->date." )";
                
            }
     
        }else if($notification->notification_type==8){
            
            
            $venue = VenueEvent::select('id','name','date','user_id')->where('id',$notification->request_id)->first();
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Venue event partaner";
                $notification_body = $user->name." accepted your request to be venue event partaner  (".$venue->name.") (".$venue->date." )";
                
            }else {
                
                $notification_title = "Venue event partaner";
                           $notification_body = $user->name." rejected your request to be venue event partaner (".$venue->name.") (".$venue->date." )";
                
            }
     
        }else if($notification->notification_type==9){
            
            
            $venue = VenueEvent::select('id','name','date','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Venue event crew";
                $notification_body = $user->name." accepted your request to be venue event crew  (".$venue->name.") (".$venue->date." )";
                
            }else {
                
                $notification_title = "Venue event crew";
                $notification_body = $user->name." rejected your request to be venue event crew (".$venue->name.") (".$venue->date." )";
                
            }
     
        }else if($notification->notification_type==10){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club president";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club president";
                
            }
     
        }else if($notification->notification_type==11){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club vice president";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club vice president";
                
            }
     
        }else if($notification->notification_type==12){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club manager";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club manager";
                
            }
     
        }else if($notification->notification_type==13){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club communication director";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club communication director";
                
            }
     
        }else if($notification->notification_type==14){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club assistant";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club assistant";
                
            }
     
        }else if($notification->notification_type==15){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==16){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club facilitator";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club facilitator";
                
            }
     
        }else if($notification->notification_type==17){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club marcher";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club marcher";
                
            }
     
        }else if($notification->notification_type==18){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club instructor";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club instructor";
                
            }
     
        }else if($notification->notification_type==19){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now the club team leader";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now the club team leader";
                
            }
     
        }else if($notification->notification_type==20){
            
            
            $venue = Club::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Club Request";
                $notification_body = $user->name." is now one of the club members";
                
            }else {
                
                    $notification_title = "Club Request";
                $notification_body = $user->name." is now one of the club members";
                
            }
     
        }else if($notification->notification_type==21){
            
            
            $venue = Team::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Team Request";
                $notification_body = $user->name." accepted your invitation to be your team owner ";
                
            }else {
                
                    $notification_title = "Team Request";
                $notification_body = $user->name." rejected your invitation to be your team owner ";
                
            }
     
        }else if($notification->notification_type==22){
            
            
            $venue = Team::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Team Request";
                $notification_body = $user->name." accepted your invitation to be your team sponser ";
                
            }else {
                
                    $notification_title = "Team Request";
                $notification_body = $user->name." rejected your invitation to be your team sponser ";
                
            }
     
        }else if($notification->notification_type==23){
            
            
            $venue = Team::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Team Request";
                $notification_body = $user->name." accepted your invitation to be your team partner ";
                
            }else {
                
                    $notification_title = "Team Request";
                $notification_body = $user->name." rejected your invitation to be your team partner ";
                
            }
     
        }else if($notification->notification_type==24){
            
            
            $venue = Team::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Team Request";
                $notification_body = $user->name." accepted your invitation to be one of your team members  ";
                
            }else {
                
                    $notification_title = "Team Request";
                $notification_body = $user->name." rejected your invitation to be one of your team members ";
                
            }
     
        }else if($notification->notification_type==25){
            
            
            $venue = Team::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Team Request";
                $notification_body = $user->name." accepted your invitation to be one of your team drivers  ";
                
            }else {
                
                    $notification_title = "Team Request";
                $notification_body = $user->name." rejected your invitation to be one of your team drivers ";
                
            }
     
        }else if($notification->notification_type==26){
            
            
            $venue = TeamParticipation::select('id','user_id','event_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Team Request";
                $notification_body = $user->name.' accepted your invitation  as a team participation in event '.Event::where('id',$venue->event_id)->first()->name;
                
            }else {
                
                    $notification_title = "Team Request";
                $notification_body = $user->name.' rejected your invitation  as a team participation in event '.Event::where('id',$venue->event_id)->first()->name;
                
            }
     
        }else if($notification->notification_type==27){
            
        
            $venue = Academy::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Academy Request";
                $notification_body = $user->name." accepted your request to be one of the academy’s crew";
                
            }else {
                
                $notification_title = "Academy Request";
                $notification_body = $user->name." rejected your request to be one of the academy’s crew";
                
            }
     
        }else if($notification->notification_type==28){
            
        
            $venue = Course::select('id','user_id','name')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Course Request";
                $notification_body = $user->name." accepted your request to be sponsor to your course ( ".$venue->name." )";
                
            }else {
                
                $notification_title = "Course Request";
               $notification_body = $user->name." rejected your request to be sponsor to your course ( ".$venue->name." )";
                
            }
     
        }else if($notification->notification_type==29){
            
        
            $venue = Course::select('id','user_id','name')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Course Request";
                 $notification_body = $user->name." accepted your request to be partner to your course ( ".$venue->name." )";
                
            }else {
                
                $notification_title = "Course Request";
                 $notification_body = $user->name." rejected your request to be partner to your course ( ".$venue->name." )";
                
            }
     
        }else if($notification->notification_type==30){
            
        
            $venue = Course::select('id','user_id','name')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Course Request";
                $notification_body = $user->name." accepted your request to be member to your course ( ".$venue->name." )";
                
            }else {
                
                $notification_title = "Course Request";
                    $notification_body = $user->name." rejected your request to be member to your course ( ".$venue->name." )";
                
            }
     
        }else if($notification->notification_type==31){
            
            
            $venue = Event::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Best Record Venue";
                $notification_body = $user->name." accepted your request to be best record at event ".$venue->name;
                
            }else {
                
                $notification_title = "Best Record Venue";
                $notification_body = $user->name." rejected your request to be best record at event ".$venue->name;
                
            }
     
        
        
            
        }else if($notification->notification_type==32){
            
            
            $venue = Event::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Event Sponser";
                $notification_body = $user->name." accepted your request to be sponser at event ".$venue->name;
                
            }else {
                
              $notification_title = "Event Sponser";
                $notification_body = $user->name." rejected your request to be sponser at event ".$venue->name;
                
            }
     
        
        
            
        }else if($notification->notification_type==33){
            
            
            $venue = Event::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Event Partner";
                $notification_body = $user->name." accepted your request to be partner at event ".$venue->name;
                
            }else {
                
              $notification_title = "Event Partner";
                $notification_body = $user->name." rejected your request to be partner at event ".$venue->name;
                
            }
     
        
        
            
        }else if($notification->notification_type==34){
            
            
            $venue = Event::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Event Partner";
                $notification_body = $user->name." accepted your request to be partner at event ".$venue->name;
                
            }else {
                
              $notification_title = "Event Partner";
                $notification_body = $user->name." rejected your request to be crew at event ".$venue->name;
                
            }
     
        
        
            
        }else if($notification->notification_type==35){
            
            
            $venue = VenueEvent::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
           // $notification->owner_id = $venue->user_id;
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "Event Join Race";
                $notification_body = $user->name." will join your event as car racer ".$venue->name;
                
                
          VenueEventMember::create([
            'venue_event_id' => $venue->id,
            'member_id'=> $user_id,
            'type'=>3
            ]);
            
                
                
            }else {
                
                $notification_title = "Event Join Race";
                $notification_body = $user->name." will join your event as car racer ".$venue->name;
                
            }
            
            $venue->racers_count = $venue->racers_count + 1;
     
            $venue->save();
        
            
        }else if($notification->notification_type==36){
            
            
            $venue = VenueEvent::select('id','user_id')->where('id',$notification->request_id)->first();
            
            
           // $notification->owner_id = $venue->user_id;
            
            $user_id = $venue->user_id;
        
            if($request->status==1){
                
                $notification_title = "User Join Race";
                $notification_body = $user->name." will join your event as car racer ".$venue->name;
                
            }else {
                
                $notification_title = "User Join Race";
                $notification_body = $user->name." will join your event as car racer ".$venue->name;
                
            }
            
            $venue->audiance = $venue->audiance + 1;
     
            $venue->save();
        
            
        }
        
        
        $tokens = User::where('id',$user_id)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
		 $this->send_multi_notification($tokens,$message_complete);
        
          Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => 0,
                   'user_id'=> $user_id,
                   'notification_type'=>0
                   ]);
                   
         
         $message_complete = array('type'=>"1",'title'=>$notification_title,'body'=>$notification_body);
         
		 $this->send_multi_notification($tokens,$message_complete);
		 
        
        $notification->save();
        
        
        return $this->apiResponse(200, null, $notification);
    }
    


    public function user_info(Request $request)
    {
        $user = User::where('id',$request->user_id)->first();
        $user['age'] = Carbon::parse($user['birthdate'])->age;
        return $this->apiResponse(200, null, new UserResource($user));
    }

    public function follow_profile(Request $request)
    {
           $user = auth()->user();
        if($user->following->contains($request->following_id)){
           $user->following()->detach($request->following_id);
        return $this->apiResponse(200,null,null);
        }
        else {
            
            
                $notification_title = "User follow";
         
        $notification_body = auth()->user()->name." started to follow you";
        
         $tokens = User::where('id',$request->following_id)->pluck('google_id');
         
         Notification::create([
                   'title'=>$notification_title,
                   'body'=>$notification_body,
                   'request_id'  => 0,
                   'user_id'=> $request->following_id,
                   'notification_type'=>0
                   ]);
                   
          
           $trip_user = User::select('google_id')->where('id',$request->following_id)->first();
		 $message_complete = array('title'=>"user follow",'body'=>auth()->user()->name." started to follow you");
		    $this->send_notification($trip_user->google_id,$message_complete);
            
            $user->following()->attach($request->following_id);
        return $this->apiResponse(200,null, null);
        }
    }
    
    
    
    
    function send_notification($token,$message_complete ){
      
      
    $tokens = array();
     
   
    
    array_push($tokens,$token);
    
 
    
    
    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }
  

    public function user_followers(Request $request)
    {
          $user = auth()->user();
          $followers = $user->followers;
          return $this->apiResponse(200, null, new UserResource($followers));
    }

    public function follow_users(Request $request)
    {
          $user = auth()->user();
          foreach ($request->follows as $follow) {
            $user->following()->attach($follow);
          }
          return $this->apiResponse(200, null, null);
    }


    public function add_crew(Request $request)
    {
          $user = auth()->user();
          
          
          $user->crew()->attach($request->crew_id,['title_id' => $request->title_id]);
          
          $von_text = $user->name." has added their crew";
          
          VonHistory::create(['user_id' => $user->id , 'text' => $von_text , 'von_id' => $user->id , 'von_type' => 'add_crew']);
          
          
          $crews = array();
          
          array_push($crews,$request->crew_id);
          
          $tokens = User::whereIn('id',$crews)->pluck('google_id');
         $message_complete = array('type'=>"1",'title'=>$request->name,'body'=>$user->name.' added you to their crew');
         
		    $this->send_multi_notification($tokens,$message_complete);
		    
		    foreach($crews as $crew){
		        
		     Notification::create([
                   'title'=>'New Crew',
                   'body'=>$user->name.' added you to their crew',
                   'request_id'  => 0,
                   'user_id'=> $crew,
                      'notification_type'=>1
                   ]); 
                   
		    }
                   
          
          
          return $this->apiResponse(200, null, $user->crew);
    }

    public function remove_from_crew(Request $request)
    {
          $user = auth()->user();
          $user->crew()->detach($request->crew_id);
          return $this->apiResponse(200, null, null);
    }

    public function my_crew()
    {
          $user = auth()->user();
          $crew = $user->crew;
          return $this->apiResponse(200, null, $crew);
    }


    public function search(Request $request)
    {
           $user = auth()->user();
           $query = User::query();
           
        if($request->keyword){
            
            
            
            if(!$request->type||$request->type=="all") {
         $users = $query->where('name','like','%'.$request->keyword.'%')->get();
            }else {
       
       
       if($request->type == "team_participation"){
           
           
          $teams = Team::where('user_id',$user->id)->get()->pluck('id');
          
          $members = TeamMember::whereIn('team_id',$teams)->get()->pluck('member_id');
           
           $users = $query->where('name','like','%'.$request->keyword.'%')->whereIn('id',$members)->get();
           
       }else {
       $users = $query->where('name','like','%'.$request->keyword.'%')->where('type','like','%'.$request->type.'%')->get();
       }
                
                
                
            }
           
           
       foreach($users as $user_item){
           $user_item->is_follow = $user->following->contains($user_item->id);
         }
      return  $this->apiResponse(200, null, SearchResource::collection($users));
             }
    }


    public function countries()
    {
         $countries = Country::select('id','name')->get();
         return $this->apiResponse(200, null, $countries);
    }

    public function cities()
    {
         $cities = City::select('id','name')->get();
         return $this->apiResponse(200, null, $cities);
    }
    
     public function cities_by_id(Request $request)
    {
         $cities = City::select('id','name')->where('country_id',$request->country_id)->get();
         return $this->apiResponse(200, null, $cities);
    }

    public function nationalities()
    {
         $nationalities = Nationality::select('id','name')->get();
         return $this->apiResponse(200, null, $nationalities);
    }

    public function regions()
    {
         $regions = Region::select('id','name')->get();
         return $this->apiResponse(200, null, $regions);
    }



   public function random_users()
   {
                $user = auth()->user();

       $users = User::select('id','name','image','type')->where('id','!=',$user->id)->get();

       foreach($users as $user){
           $user->image =  asset('images/').'/'. $user->image ;
       }
      return $this->apiResponse(200,null, $users);

  }
  
  
   public function all_users()
   {


       $users = User::get();

      return $this->apiResponse(200,null, SearchResource::collection($users));

  }

   function send_multi_notification($tokens,$message_complete ){


    $url = 'https://fcm.googleapis.com/fcm/send';
    $fields = array(
        'registration_ids' => $tokens,
        'notification' => $message_complete
    );

    $headers = array(
        'Authorization:key=AAAAbxLNJ38:APA91bGE9fP5ani91n2BYL8m1HRJHIo_cuupDsvDnvW9EwR56iwfqb7NdtKnonlwAnNvDo9EXL-TnL2080axUwYWAt_wDex7uK9uNZQBM7L6eltT1KwWxOqjK6onYuyR9q0SyWhPjX7W', //Change API KEY HERE
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST, 0);  
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    
    $result = curl_exec($ch);  
    
   

    if ($result === FALSE) {
        die('Curl failed: ' . curl_error($ch));
    }
    curl_close($ch);
    
  }


}
