<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EventResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'details' => $this->details,
            'image' => $this->image != null ? asset('images/').'/'. $this->image : null,
            'date' => $this->date,
            'status' => $this->status,
            'user' => $this->user->name,
            'street_race_venue' => $this->street_race_venue,
            'lat' => $this->lat,
            'long' => $this->long,
            'shampionship_id' => $this->shampionship_id,
            'racer_capicity' => $this->racer_capicity,
            'audience_capicity' => $this->audience_capicity,
            'length' => $this->length,
            'turns_number' => $this->turns_number,
            'description' => $this->description,
            'sponsor_id' => $this->sponsor->name,
            'partner_id' => $this->partner->name,
        ];
    }
}
