<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PostResource extends JsonResource
{
    public function toArray($request)
    {
        return [
          'id' => $this->id,
          'text' => $this->text,
          'media_type' => $this->media_type,
          'youtube'=>$this->youtube,
          'media' => $this->media_type == 'video' ? asset('images/').'/'. $this->media : null,
          'user' => $this->user->name,
          'user_image' => $this->user->image != null ? asset('images/').'/'. $this->user->image : null,
          'background_image' => $this->user->background_image != null ? asset('images/').'/'. $this->user->background_image : null,
          'user_type' =>  $this->user->type,
          'user_id' =>  $this->user->id,
          'privacy' => $this->privacy,
          'created_at' => $this->created_at,
          'added_at' => $this->added_at,
          'images' => ImageResource::collection($this->images),
          'likes_count' => count ($this->likes),
          'comments_count' => count ($this->comments),
          'is_liked' => $this->is_liked,
          'is_saved' => $this->is_saved,
          'comments_count' => $this->comments_count,
          'comment' => $this->comment,
          'turn_off_comment'=>$this->turn_off_comment
        ];
    }
}

