<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Album extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = ['name','user_id'];


    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }


    public function images()
    {
        return $this->hasMany(AlbumMedia::class, 'album_id', 'id');
    }
}
