<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Club extends Model
{
    use HasFactory;
    
    protected $fillable = ['owner_id','president_id','vice_president_id','manager_id','communication_director_id','assistant_id','facilitator_id','marcher_id','instructor_id','user_id','team_leader_id'];
    
    
    public function owner()
    {
        return $this->belongsTo(User::class, 'owner_id', 'id');
    }
    
    
    public function president()
    {
        return $this->belongsTo(User::class, 'president_id', 'id');
    }
    
    
    public function vice_president()
    {
        return $this->belongsTo(User::class, 'vice_president_id', 'id');
    }
    
    
    public function manager()
    {
        return $this->belongsTo(User::class, 'manager_id', 'id');
    }
    
    
    public function communication_director()
    {
        return $this->belongsTo(User::class, 'communication_director_id', 'id');
    }
    
    
    public function assistant()
    {
        return $this->belongsTo(User::class, 'assistant_id', 'id');
    }
    
    
    public function facilitator()
    {
        return $this->belongsTo(User::class, 'facilitator_id', 'id');
    }
    
    
    public function marcher()
    {
        return $this->belongsTo(User::class, 'marcher_id', 'id');
    }
    
    
    public function instructor()
    {
        return $this->belongsTo(User::class, 'instructor_id', 'id');
    }
    
    
    public function team_leader()
    {
        return $this->belongsTo(User::class, 'team_leader_id', 'id');
    }
}
