<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model
{
    use HasFactory , SoftDeletes;

    protected $fillable = ['text','media','media_type' ,'youtube', 'privacy' ,'user_id','turn_off_comment'];

    public function user()
    {
        return $this->belongsTo(User::class , 'user_id','id');
    }

    public function images()
    {
        return $this->hasMany(Image::class , 'post_id','id');
    }

    public function comments()
    {
        return $this->hasMany(Comment::class, 'post_id', 'id');
    }

    public function likes()
    {
        return $this->belongsToMany(User::class, 'likes', 'post_id','user_id');
    }
}
