<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\JsonResponse;

class PostRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }


    public function rules()
    {

                    return [
                        'text' => 'required',
                        'media' => 'nullable|file',
                        'media_type' => 'required|in:image,video,voice,file',
                        'privacy' => 'required|min:6',
                        'user_id' => 'required|min:6',
                    ];
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
{
    $response = new JsonResponse([
                'status_code' => 422 ,
                'message' => 'The given data is invalid',
            ], 200);

    throw new \Illuminate\Validation\ValidationException($validator, $response);
}
}
