<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BrakeKit;
use App\Models\Cam;
use App\Models\Camera;
use App\Models\Car;
use App\Models\CarBrand;
use App\Models\CarCylinder;
use App\Models\CarEngineCc;
use App\Models\CarMake;
use App\Models\CarModel;
use App\Models\CarModelVersions;
use App\Models\CarTorque;
use App\Models\CarVersion;
use App\Models\CarYear;
use App\Models\Clutch;
use App\Models\CoilOvers;
use App\Models\ConnectingRods;
use App\Models\ControlArms;
use App\Models\Cooling;
use App\Models\Crank;
use App\Models\Differentials;
use App\Models\DownPipes;
use App\Models\EcuIgnitionCall;
use App\Models\EngineBrand;
use App\Models\EngineCc;
use App\Models\EngineYear;
use App\Models\Event;
use App\Models\Exhaust;
use App\Models\Exterior;
use App\Models\FilterIntake;
use App\Models\FlyWheel;
use App\Models\FuelBump;
use App\Models\FuelRegular;
use App\Models\Header;
use App\Models\HydraulicHandBrake;
use App\Models\IgnitionCall;
use App\Models\Injectors;
use App\Models\Interior;
use App\Models\JobTitle;
use App\Models\Lens;
use App\Models\LinkingWires;
use App\Models\Manifold;
use App\Models\MidPipes;
use App\Models\NaSuperChargoTurbo;
use App\Models\NoCylinder;
use App\Models\Nos;
use App\Models\Oil;
use App\Models\Participation;
use App\Models\Pistons;
use App\Models\RearSection;
use App\Models\Retainer;
use App\Models\RimBrand;
use App\Models\RimSize;
use App\Models\SparkPlugs;
use App\Models\SteeringAngel;
use App\Models\SteeringBox;
use App\Models\TierBrand;
use App\Models\Transmutation;
use App\Models\ValueSpring;
use Exception;
use Illuminate\Http\Request;

class CarController extends Controller
{


    public function get_car_makes()
    {
       $data = CarMake::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_car_years()
    {
       $data = CarYear::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_car_models()
    {
       $data = CarModel::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_car_model_versions()
    {
       $data = CarModelVersions::get();
       return $this->apiResponse(200 , null , $data);
    }

    public function get_manifolds()
    {
       $data = Manifold::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_mid_pipes()
    {
       $data = MidPipes::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_down_pipes()
    {
       $data = DownPipes::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_rear_sections()
    {
       $data = RearSection::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_steering_angels()
    {
       $data = SteeringAngel::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_steering_boxes()
    {
       $data = SteeringBox::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_tier_brands()
    {
       $data = TierBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_rim_brands()
    {
       $data = RimBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_rim_sizes()
    {
       $data = RimSize::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_ignition_calls()
    {
       $data = IgnitionCall::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_spark_plugs()
    {
       $data = SparkPlugs::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_linking_wires()
    {
       $data = LinkingWires::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_ecu_ignition_calls()
    {
       $data = EcuIgnitionCall::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_coolings()
    {
       $data = Cooling::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_filter_intakes()
    {
       $data = FilterIntake::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_interiors()
    {
       $data = Interior::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_oils()
    {
       $data = Oil::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_exteriors()
    {
       $data = Exterior::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_coil_overs()
    {
       $data = CoilOvers::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_brake_kits()
    {
       $data = BrakeKit::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_control_arms()
    {
       $data = ControlArms::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_hydraulic_hand_brakes()
    {
       $data = HydraulicHandBrake::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_injectors()
    {
       $data = Injectors::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_fuel_bumps()
    {
       $data = FuelBump::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_fuel_regulars()
    {
       $data = FuelRegular::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_exhausts()
    {
       $data = Exhaust::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_headers()
    {
       $data = Header::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_engine_brands()
    {
       $data = EngineBrand::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_engine_year()
    {
       $data = EngineYear::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_no_cylinders()
    {
       $data = CarCylinder::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_engine_cc()
    {
       $data = CarEngineCc::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_nos()
    {
       $data = Nos::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_na_super_chargo_turbos()
    {
       $data = NaSuperChargoTurbo::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_pistons()
    {
       $data = Pistons::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_connecting_rods()
    {
       $data = ConnectingRods::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_cranks()
    {
       $data = Crank::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_cams()
    {
       $data = Cam::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_value_springs()
    {
       $data = ValueSpring::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_retainers()
    {
       $data = Retainer::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_transmutations()
    {
       $data = Transmutation::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_differentials()
    {
       $data = Differentials::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_clutches()
    {
       $data = Clutch::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function get_fly_wheels()
    {
       $data = FlyWheel::get();
       return $this->apiResponse(200 , null , $data);
    }


    public function save_car(Request $request)
    {
        $user = auth()->user();
        $car = Car::create($request->all());
        $car->user_id =  $user->id;
        $car->save();

        if($request->hasFile('image')){
        $image = $request->file('image');
        $image_name = time() . '-' . $image->getClientOriginalName();
        $image_path = public_path().'/images';
        $image->move($image_path,$image_name);
        $car->image = $image_name;
        $car->save();
        }
        return $this->apiResponse(200 , null , $car);
    }


    public function get_cars(Request $request)
    {
       $cars = Car::select('id','image','car_brand_id','car_year','car_model_id','car_version_id')->where('user_id',$request->user_id)->get();

       foreach($cars as $car){
            $car->car_brand = CarBrand::select('id','name')->where('id',$car->car_brand_id)->first();
            $car->car_model = CarModel::select('id','name')->where('id',$car->car_model_id)->first();
            $car->car_version = CarVersion::select('id','name')->where('id',$car->car_version_id)->first();
       }

       return $this->apiResponse(200 , null , $cars);
    }


    public function get_car_details(Request $request)
    {
            $car = Car::where('id',$request->car_id)->first();
            $car->car_brand = CarBrand::select('id','name')->where('id',$car->car_brand_id)->first();
            $car->car_model = CarModel::select('id','name')->where('id',$car->car_model_id)->first();
            $car->car_version = CarVersion::select('id','name')->where('id',$car->car_version_id)->first();
       return $this->apiResponse(200 , null , $car);
    }


    public function get_participations(Request $request)
    {

       $participations = Participation::select('id','year','padiums','participations','champions','rank','event_id','user_id')->where('user_id',$request->user_id)->get();

       foreach($participations as $participation){

            $participation->event = Event::select('id','name')->where('id',$participation->event_id)->first();
       }
       return $this->apiResponse(200 , null , $participations);
    }

    public function set_participations(Request $request)
    {
       $participations = Participation::create([
       'year' => $request->year,
       'padiums' => $request->padiums,
       'participations'  => $request->participations,
       'champions'  =>  $request->champions,
       'rank'  => $request->rank,
       'event_id'  => $request->event_id,
       'user_id'  => auth()->user()->id,
        ]);

       return $this->apiResponse(200 , null , $participations);
    }


    public function remove_participations(Request $request)
    {
        $user = auth()->user();
        $participation = Participation::where('id',$request->participation_id)->first();

       if($participation->user_id == $user->id){
        $participation->delete();
        return $this->apiResponse(200 , null , $participation);
       } else {
        return $this->apiResponse(401 , 'you are not authorized' , $participation);
       }
    }



    public function remove_car(Request $request)
    {
        $user = auth()->user();
        $car = Car::where('id',$request->car_id)->first();

       if($car->user_id == $user->id){
        $car->delete();
        return $this->apiResponse(200 , null , $car);
       } else {
        return $this->apiResponse(401 , 'you are not authorized' , $car);
       }

    }

    public function addData()
    {
          $file = public_path('done.csv');
          $customerArr = $this->csvToArray($file);

            foreach($customerArr as $item){

                try{

                 CarTorque::create(['name'=>$item['torque']]);
                }catch(Exception $ex){

                }
            }
        return $customerArr;
    }


   public function csvToArray($filename = '', $delimiter = ',')
    {
        if (!file_exists($filename) || !is_readable($filename))
            return false;

        $header = null;
        $data = array();
        if (($handle = fopen($filename, 'r')) !== false)
        {
            while (($row = fgetcsv($handle, 1000, $delimiter)) !== false)
            {
                if (!$header)
                    $header = $row;
                else
                    $data[] = array_combine($header, $row);
            }
            fclose($handle);
        }

        return $data;
    }

}



