<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Tymon\JWTAuth\Contracts\JWTSubject;


class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens, HasFactory, Notifiable , SoftDeletes ;


    protected $fillable = ['name','email','password','type','mobile','nationality_id','birthdate','country_id','city_id','region_id','address','about','website','facebook','instgram','youtube','forget_code','image','background_image'];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    public function interests(){
        return $this->belongsToMany(Interest::class , 'interest_user','user_id','interest_id');
    }

    public function likes(){
        return $this->belongsToMany(Post::class , 'likes','user_id','post_id');
    }

    public function city()
    {
        return $this->belongsTo(City::class , 'city_id','id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class , 'country_id','id');
    }

    public function region()
    {
        return $this->belongsTo(Region::class , 'region_id','id');
    }

    public function nationality()
    {
        return $this->belongsTo(Nationality::class , 'nationality_id','id');
    }

    public function crew()
    {
        return $this->belongsToMany(User::class ,'crews' , 'user_id','crew_id')->withPivot('title_id');
    }

    public function cameras()
    {
        return $this->belongsToMany(Camera::class , 'camera_user' , 'user_id','camera_id');
    }

    public function lenses()
    {
        return $this->belongsToMany(Lens::class , 'lens_user' , 'user_id','lens_id');
    }

    public function albums()
    {
        return $this->hasMany(Album::class, 'user_id', 'id');
    }

    public function following()
    {
        return $this->belongsToMany(User::class, 'follows', 'user_id' , 'following_id');
    }

    public function followers()
    {
        return $this->belongsToMany(User::class, 'follows',  'following_id' , 'user_id' );
    }


}
